/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringDiagramBeansProcessingModel;
import com.intellij.spring.perspectives.diagrams.SpringDiagramCategoryManager;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDiagramDataModel
extends SpringDiagramBeansProcessingModel {
    private final SpringElementWrapper myElement;
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;

    public SpringDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider, @Nullable SpringElementWrapper element) {
        super(project, springBaseBeanPointerDiagramProvider);
        this.myElement = element;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel$1", "eventOccured"));
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(new MessageHandler(){

            public void handle(@NotNull Method event, Object ... params) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                SpringDiagramDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel$3", "handle"));
            }
        });
        messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        messageBusConnection.subscribe(ProjectTopics.MODULES);
    }

    public void refreshDataModel() {
        if (DumbService.isDumb((Project)this.getProject())) {
            return;
        }
        this.clearAll();
        this.updateDataModel();
    }

    protected void updateDataModel() {
        CommonSpringModel applicationModel = this.getActualModel();
        if (applicationModel == null) {
            return;
        }
        Collection<SpringBeanPointer> pointers = applicationModel.getAllCommonBeans();
        THashSet pointerSet = new THashSet(pointers);
        for (SpringBeanPointer pointer : pointers) {
            DiagramNode<SpringElementWrapper> sourceNode = this.getOrCreateElement(pointer, applicationModel);
            if (sourceNode == null) continue;
            this.processDependencies(applicationModel, (Set<SpringBeanPointer>)pointerSet, pointer, sourceNode);
        }
        if (this.isSelectionMode()) {
            DiagramUtils.removeNonSelectedDependencies((DiagramDataModel)this);
        }
    }

    @Override
    protected CommonSpringModel getActualModel() {
        return this.getApplicationModel(this.getBuilder().getPresentation().isCategoryEnabled(SpringDiagramCategoryManager.LOCAL));
    }

    @Nullable
    public CommonSpringModel getApplicationModel(boolean isLocalModel) {
        return this.myElement == null ? null : this.myElement.getProcessingSpringModel(isLocalModel);
    }

    protected boolean isSelectionMode() {
        return DiagramUtils.isSelectionMode((DiagramBuilder)this.getBuilder());
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringDiagramDataModel springDiagramDataModel = this;
        if (springDiagramDataModel == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(0);
        }
        return springDiagramDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @Override
    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    @NotNull
    public String getNodeName(DiagramNode<SpringElementWrapper> n) {
        SpringElementWrapper identifyingElement = (SpringElementWrapper)n.getIdentifyingElement();
        if (identifyingElement instanceof SpringBeanPointerWrapper) {
            SpringBeanPointer beanPointer = (SpringBeanPointer)((SpringBeanPointerWrapper)identifyingElement).getWrapped();
            return beanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName(beanPointer) : "";
        }
        String string = identifyingElement.getName();
        if (string == null) {
            SpringDiagramDataModel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/perspectives/diagrams/SpringDiagramDataModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

