/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomSpringBeanImpl
extends AbstractDomSpringBean
implements DomSpringBean {
    @Override
    @Nullable
    public String getBeanName() {
        BeanName beanName = (BeanName)DomReflectionUtil.findAnnotationDFS(this.getClass(), BeanName.class);
        if (beanName == null) {
            return DomUtil.hasXml((DomElement)this.getId()) ? this.getId().getRawText() : null;
        }
        String value = beanName.value();
        if (!value.isEmpty()) {
            return value;
        }
        Class<? extends BeanNameProvider> providerClass = beanName.provider();
        if (providerClass == BeanNameProvider.class) {
            throw new IllegalStateException("@BeanName: no value() given, provider() must be set" + this.getDomElementType());
        }
        return SpringCommonUtils.getBeanNameProvider(providerClass).getBeanName(this);
    }

    @Override
    public void setName(@NotNull String newName) {
        if (newName == null) {
            DomSpringBeanImpl.$$$reportNull$$$0(0);
        }
        if (DomUtil.hasXml((DomElement)this.getId())) {
            this.getId().setStringValue(newName);
        }
    }

    @Override
    @Nullable
    public final String getClassName() {
        BeanType beanType = (BeanType)DomReflectionUtil.findAnnotationDFS(this.getClass(), BeanType.class);
        if (beanType == null) {
            return null;
        }
        String value = beanType.value();
        if (!value.isEmpty()) {
            return value;
        }
        Class<? extends BeanTypeProvider> providerClass = beanType.provider();
        if (providerClass == BeanTypeProvider.class) {
            throw new IllegalStateException("@BeanType: no value() given, provider() must be set" + this.getDomElementType());
        }
        return SpringCommonUtils.getBeanTypeProvider(providerClass).getBeanType(this);
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = DomUtil.getFile((DomElement)this);
        if (xmlFile == null) {
            DomSpringBeanImpl.$$$reportNull$$$0(1);
        }
        return xmlFile;
    }

    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        if (!this.isValid()) {
            return null;
        }
        return PomService.convertToPsi((Project)this.getManager().getProject(), (PomTarget)BeanService.getInstance().createSpringBeanPsiTarget(this));
    }

    @Override
    public String @NotNull [] getAliases() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            DomSpringBeanImpl.$$$reportNull$$$0(2);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.getManager().getProject());
    }

    @Override
    public Beans getBeansParent() {
        return (Beans)DomUtil.getParentOfType((DomElement)this, Beans.class, (boolean)false);
    }

    @Override
    @NotNull
    public Collection<SpringQualifier> getSpringQualifiers() {
        Set<SpringQualifier> set = Collections.singleton(DefaultSpringBeanQualifier.create(this));
        if (set == null) {
            DomSpringBeanImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/DomSpringBeanImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/DomSpringBeanImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

