/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class SpringValueConditionFactory {
    public static Condition<GenericDomValue> createPropertyNameCondition(@NotNull String propertyName) {
        if (propertyName == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(0);
        }
        return genericDomValue -> SpringValueConditionFactory.checkPropertyName((DomElement)genericDomValue, propertyName);
    }

    public static Condition<GenericDomValue> createBeanPropertyCondition(@NotNull String beanClass, String ... propertyNames) {
        if (beanClass == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(1);
        }
        if (propertyNames == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(2);
        }
        return genericDomValue -> {
            for (String propertyName : propertyNames) {
                if (!SpringValueConditionFactory.checkPropertyName((DomElement)genericDomValue, propertyName)) continue;
                return SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
            }
            return false;
        };
    }

    public static Condition<GenericDomValue> createBeanClassCondition(@NotNull String beanClass) {
        if (beanClass == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(3);
        }
        return genericDomValue -> SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
    }

    public static Condition<GenericDomValue> createBeanClassConstructorArgCondition(@NotNull String beanClass) {
        if (beanClass == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(4);
        }
        return genericDomValue -> SpringValueConditionFactory.isConstructorArg(genericDomValue) && SpringValueConditionFactory.checkBeanClass((DomElement)genericDomValue, beanClass);
    }

    private static boolean isConstructorArg(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(5);
        }
        return genericDomValue.getParentOfType(ConstructorArg.class, false) != null;
    }

    private static boolean checkBeanClass(@NotNull DomElement element, @NotNull String beanClassName) {
        DomSpringBean springBean;
        if (element == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(6);
        }
        if (beanClassName == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(7);
        }
        if ((springBean = SpringConverterUtil.getCurrentBean(element)) == null) {
            return false;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        return InheritanceUtil.isInheritor((PsiClass)beanClass, (String)beanClassName);
    }

    private static boolean checkPropertyName(@NotNull DomElement element, @NotNull String propertyName) {
        SpringProperty springProperty;
        if (element == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            SpringValueConditionFactory.$$$reportNull$$$0(9);
        }
        return (springProperty = (SpringProperty)element.getParentOfType(SpringProperty.class, false)) != null && propertyName.equals(springProperty.getName().getStringValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClassName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/values/converters/SpringValueConditionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPropertyNameCondition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createBeanPropertyCondition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createBeanClassCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBeanClassConstructorArgCondition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructorArg";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBeanClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPropertyName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

