/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.values.SpringValueConvertersProvider;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class SpringValueConvertersRegistry
extends GenericDomValueConvertersRegistry {
    public static GenericDomValueConvertersRegistry getInstance() {
        return (GenericDomValueConvertersRegistry)ApplicationManager.getApplication().getService(SpringValueConvertersRegistry.class);
    }

    protected SpringValueConvertersRegistry() {
        this.registerBuiltinValueConverters();
    }

    @Nullable
    protected Converter<?> getCustomConverter(Pair<PsiType, GenericDomValue> pair) {
        for (SpringValueConvertersProvider provider : SpringValueConvertersProvider.EP.getExtensionList()) {
            Condition<Pair<PsiType, GenericDomValue>> condition = provider.getCondition();
            if (!condition.value(pair)) continue;
            return provider.getConverter();
        }
        return null;
    }

    protected abstract void registerBuiltinValueConverters();
}

