/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderPropertyReference;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.spring.model.xml.util.UtilProperties;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.text.PlaceholderTextRanges;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderUtilsImpl
extends PlaceholderUtils {
    private static final Pair<String, String> DEFAULT_PLACEHOLDER_PAIR = Pair.create((Object)"${", (Object)"}");
    @NonNls
    private static final String LOCATION_PROPERTY_NAME = "location";
    @NonNls
    private static final String LOCATIONS_PROPERTY_NAME = "locations";
    @NonNls
    private static final String PROPERTIES_PROPERTY_NAME = "properties";
    @NonNls
    private static final String PROPERTIES_ARRAY_PROPERTY_NAME = "propertiesArray";
    private static final Key<CachedValue<Set<Pair<String, String>>>> PLACEHOLDER_PREFIXES_KEY = Key.create((String)"PLACEHOLDER_PREFIX_SUFFIX");
    private static final Key<CachedValue<Pair<String, String>>> PLACEHOLDER_PREFIX_SUFFIX = Key.create((String)"PLACEHOLDER_PREFIX_SUFFIX");

    @Override
    public Set<PropertiesFile> getResources(Collection<? extends SpringBeanPointer> configurerBeans) {
        LinkedHashSet<PropertiesFile> resources = new LinkedHashSet<PropertiesFile>();
        for (SpringBeanPointer springBeanPointer : configurerBeans) {
            this.getResources(springBeanPointer, resources);
        }
        return resources;
    }

    private boolean getResources(SpringBeanPointer configurerBean, Set<PropertiesFile> resources) {
        List<Pair<String, PsiElement>> locations = this.getLocations((CommonSpringBean)configurerBean.getSpringBean());
        boolean hasNotResolvedLocations = false;
        for (Pair<String, PsiElement> location : locations) {
            Set<PropertiesFile> propertiesFiles = this.getPropertiesFile(location);
            if (!propertiesFiles.isEmpty()) {
                resources.addAll(propertiesFiles);
                continue;
            }
            hasNotResolvedLocations = true;
        }
        return hasNotResolvedLocations && !locations.isEmpty();
    }

    @Override
    @NotNull
    public Set<PropertiesFile> getPropertiesFile(Pair<String, PsiElement> location) {
        PsiElement psiElement = (PsiElement)location.second;
        String value = (String)location.first;
        if (psiElement == null || value == null) {
            Set<PropertiesFile> set = Collections.emptySet();
            if (set == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(0);
            }
            return set;
        }
        return new LinkedHashSet<PropertiesFile>(PlaceholderUtilsImpl.getResourceFiles(psiElement, value, ",", (Condition<PsiFileSystemItem>)new FilteringIterator.InstanceOf(PsiFile.class)));
    }

    @Override
    public List<Pair<String, PsiElement>> getLocations(CommonSpringBean configurerBean) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)configurerBean.getXmlTag(), () -> {
            SpringPropertyDefinition propertiesArrayProperty;
            SpringBeanPointer propertiesRefBean;
            SmartList locations = new SmartList();
            if (configurerBean instanceof PropertyPlaceholder) {
                SpringBeanPointer propertiesBeanPointer;
                PropertyPlaceholder placeholder = (PropertyPlaceholder)configurerBean;
                GenericAttributeValue<String> location = placeholder.getLocation();
                if (location.getRawText() != null && location.getXmlElement() != null) {
                    PlaceholderUtilsImpl.addIfNotNull((List<Pair<String, PsiElement>>)locations, location.getRawText(), location.getXmlElement());
                }
                if ((propertiesBeanPointer = (SpringBeanPointer)placeholder.getPropertiesRef().getValue()) != null) {
                    PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, propertiesBeanPointer);
                }
            } else {
                SpringPropertyDefinition locationProperty = SpringPropertyUtils.findPropertyByName(configurerBean, LOCATION_PROPERTY_NAME);
                if (locationProperty != null) {
                    PlaceholderUtilsImpl.addIfNotNull((List<Pair<String, PsiElement>>)locations, PlaceholderUtilsImpl.getPropertyValue(locationProperty));
                }
                PlaceholderUtilsImpl.processLocationsProperty((List<Pair<String, PsiElement>>)locations, configurerBean);
            }
            SpringPropertyDefinition propertiesProperty = SpringPropertyUtils.findPropertyByName(configurerBean, PROPERTIES_PROPERTY_NAME);
            if (propertiesProperty != null && (propertiesRefBean = propertiesProperty.getRefValue()) != null) {
                PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, propertiesRefBean);
                PlaceholderUtilsImpl.processLocationsProperty((List<Pair<String, PsiElement>>)locations, propertiesRefBean.getSpringBean());
            }
            if ((propertiesArrayProperty = SpringPropertyUtils.findPropertyByName(configurerBean, PROPERTIES_ARRAY_PROPERTY_NAME)) != null) {
                GenericDomValue<SpringBeanPointer> element = propertiesArrayProperty.getRefElement();
                if (element != null) {
                    PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, (SpringBeanPointer)element.getValue());
                }
                if (propertiesArrayProperty instanceof SpringProperty) {
                    PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getList());
                    PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getSet());
                    PlaceholderUtilsImpl.addLocations((List<Pair<String, PsiElement>>)locations, ((SpringProperty)propertiesArrayProperty).getArray());
                }
            }
            return CachedValueProvider.Result.create((Object)locations, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static Pair<String, PsiElement> getPropertyValue(@NotNull SpringPropertyDefinition property) {
        GenericDomValue<?> value;
        if (property == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(1);
        }
        return (value = PlaceholderUtilsImpl.getPropertyDomValue(property)) == null ? null : Pair.create((Object)value.getRawText(), (Object)DomUtil.getValueElement(value));
    }

    @Nullable
    private static GenericDomValue<?> getPropertyDomValue(@NotNull SpringPropertyDefinition property) {
        GenericDomValue<?> valueElement;
        if (property == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(2);
        }
        return (valueElement = property.getValueElement()) != null && valueElement.getRawText() == null ? null : valueElement;
    }

    private static void addIfNotNull(List<Pair<String, PsiElement>> locations, Pair<String, PsiElement> pair) {
        if (pair != null && pair.first != null && pair.second != null) {
            locations.add(pair);
        }
    }

    private static void processLocationsProperty(List<Pair<String, PsiElement>> locations, CommonSpringBean bean) {
        SpringPropertyDefinition locationsProperty = SpringPropertyUtils.findPropertyByName(bean, LOCATIONS_PROPERTY_NAME);
        if (locationsProperty instanceof SpringProperty) {
            Pair<String, PsiElement> propertyValue = PlaceholderUtilsImpl.getPropertyValue(locationsProperty);
            if (propertyValue != null) {
                PlaceholderUtilsImpl.addIfNotNull(locations, propertyValue);
            } else {
                SpringProperty springProperty = (SpringProperty)locationsProperty;
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getList());
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getSet());
                PlaceholderUtilsImpl.addLocationsFromCollection(locations, springProperty.getArray());
            }
        }
    }

    private static void addLocationsFromCollection(List<Pair<String, PsiElement>> locations, ListOrSet list) {
        for (SpringValue value : list.getValues()) {
            for (String s : PlaceholderUtilsImpl.splitLocationString(value.getRawText())) {
                PlaceholderUtilsImpl.addIfNotNull(locations, s, value.getXmlElement());
            }
        }
    }

    private static void addLocations(List<Pair<String, PsiElement>> locations, ListOrSet listOrSet) {
        for (SpringRef value : listOrSet.getRefs()) {
            PlaceholderUtilsImpl.addLocations(locations, (SpringBeanPointer)value.getBean().getValue());
            PlaceholderUtilsImpl.addLocations(locations, (SpringBeanPointer)value.getLocal().getValue());
        }
    }

    private static void addLocations(List<Pair<String, PsiElement>> locations, @Nullable SpringBeanPointer beanPointer) {
        Object springBean;
        GenericDomValue<String> location;
        if (beanPointer != null && (location = PlaceholderUtilsImpl.getLocationDomElementValue(springBean = beanPointer.getSpringBean())) != null) {
            String locationString = location.getRawText();
            for (String s : PlaceholderUtilsImpl.splitLocationString(locationString)) {
                PlaceholderUtilsImpl.addIfNotNull(locations, s.trim(), DomUtil.getValueElement(location));
            }
        }
    }

    private static void addIfNotNull(@NotNull List<Pair<String, PsiElement>> locations, @Nullable String str, @Nullable XmlElement valueElement) {
        if (locations == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(3);
        }
        if (str != null && valueElement != null) {
            locations.add((Pair<String, PsiElement>)Pair.create((Object)str, (Object)valueElement));
        }
    }

    @NotNull
    private static Set<String> splitLocationString(@Nullable String location) {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        if (!StringUtil.isEmptyOrSpaces((String)location)) {
            for (String s : StringUtil.split((String)location, (String)",")) {
                if (StringUtil.isEmptyOrSpaces((String)s)) continue;
                locations.add(s.trim());
            }
        }
        LinkedHashSet<String> linkedHashSet = locations;
        if (linkedHashSet == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @Nullable
    private static GenericDomValue<String> getLocationDomElementValue(CommonSpringBean springBean) {
        SpringPropertyDefinition location;
        PsiClass psiClass;
        if (springBean instanceof UtilProperties) {
            UtilProperties utilProperties = (UtilProperties)springBean;
            return utilProperties.getLocation();
        }
        if (springBean instanceof SpringBean && (psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) != null && "org.springframework.beans.factory.config.PropertiesFactoryBean".equals(psiClass.getQualifiedName()) && (location = SpringPropertyUtils.findPropertyByName(springBean, LOCATION_PROPERTY_NAME)) != null) {
            return location.getValueElement();
        }
        return null;
    }

    @Override
    public boolean containsDefaultPlaceholderDefinitions(@NotNull GenericDomValue genericDomValue) {
        String stringValue;
        if (genericDomValue == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(5);
        }
        if ((stringValue = genericDomValue.getRawText()) != null && !StringUtil.isEmptyOrSpaces((String)stringValue)) {
            return PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR);
        }
        return false;
    }

    @Override
    public boolean isRawTextPlaceholder(GenericDomValue genericDomValue) {
        return this.isPlaceholder(genericDomValue, genericDomValue.getRawText());
    }

    @Override
    public boolean isPlaceholder(GenericDomValue genericDomValue) {
        return this.isPlaceholder(genericDomValue, genericDomValue.getStringValue());
    }

    @Override
    public boolean isPlaceholder(GenericDomValue genericDomValue, String stringValue) {
        if (stringValue != null && !StringUtil.isEmptyOrSpaces((String)stringValue)) {
            if (PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR)) {
                return true;
            }
            if (DomUtil.hasXml((DomElement)genericDomValue)) {
                XmlElement element = genericDomValue.getXmlElement();
                Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes((PsiElement)element);
                if (prefixes == null) {
                    return false;
                }
                for (Pair<String, String> pair : prefixes) {
                    if (!PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, pair)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isPlaceholder(String stringValue, List<SpringBeanPointer> configurers) {
        for (SpringBeanPointer configurer : configurers) {
            Object bean = configurer.getSpringBean();
            if (!(bean instanceof DomSpringBean) || !PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, this.getPlaceholderPrefixAndSuffix((DomSpringBean)bean))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultPlaceholder(@Nullable String stringValue) {
        return stringValue != null && PlaceholderUtilsImpl.isPrefixAndSuffixDefinedCorrectly(stringValue, DEFAULT_PLACEHOLDER_PAIR);
    }

    private static boolean isPrefixAndSuffixDefinedCorrectly(@NotNull String stringValue, @NotNull Pair<String, String> prefixAndSuffix) {
        int prefixPos;
        if (stringValue == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(6);
        }
        if (prefixAndSuffix == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(7);
        }
        return (prefixPos = stringValue.indexOf((String)prefixAndSuffix.first)) >= 0 && prefixPos < stringValue.indexOf((String)prefixAndSuffix.second);
    }

    @Override
    public Pair<String, String> getPlaceholderPrefixAndSuffix(DomSpringBean placeholderBean) {
        return (Pair)CachedValuesManager.getManager((Project)placeholderBean.getPsiManager().getProject()).getCachedValue((UserDataHolder)placeholderBean, PLACEHOLDER_PREFIX_SUFFIX, () -> new CachedValueProvider.Result(this.getPlaceholderPrefixAndSuffixInner(placeholderBean), new Object[]{placeholderBean.getXmlElement()}), false);
    }

    @Override
    @NotNull
    public Pair<String, String> getPlaceholderPrefixAndSuffixInner(@Nullable SpringBeanPointer pointer) {
        Object springBean;
        if (pointer != null && (springBean = pointer.getSpringBean()) instanceof DomSpringBean) {
            Pair<String, String> pair = this.getPlaceholderPrefixAndSuffixInner((DomSpringBean)springBean);
            if (pair == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair<String, String> pair = DEFAULT_PLACEHOLDER_PAIR;
        if (pair == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, String> getPlaceholderPrefixAndSuffixInner(DomSpringBean placeholderBean) {
        String prefix = PlaceholderUtilsImpl.getPlaceholderConfigProperty(placeholderBean, "placeholderPrefix", "${");
        String suffix = PlaceholderUtilsImpl.getPlaceholderConfigProperty(placeholderBean, "placeholderSuffix", "}");
        Pair pair = Pair.create((Object)prefix, (Object)suffix);
        if (pair == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private static String getPlaceholderConfigProperty(DomSpringBean placeholderBean, String propertyName, String defaultValue) {
        String value;
        SpringPropertyDefinition userDefinedPrefixProperty = SpringPropertyUtils.findPropertyByName(placeholderBean, propertyName);
        if (userDefinedPrefixProperty != null && userDefinedPrefixProperty.getValueElement() != null && !StringUtil.isEmptyOrSpaces((String)(value = userDefinedPrefixProperty.getValueElement().getRawText()))) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public PsiReference @NotNull [] createPlaceholderPropertiesReferences(GenericDomValue genericDomValue) {
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(genericDomValue);
        if (textRanges == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(11);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        return PlaceholderUtilsImpl.createPlaceholderPropertiesReferences(textRanges, (PsiElement)valueElement);
    }

    @Override
    public PsiReference @NotNull [] createPlaceholderPropertiesReferences(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(12);
        }
        return PlaceholderUtilsImpl.createPlaceholderPropertiesReferences(this.getTextRangesWithNested(psiElement), psiElement);
    }

    private static PsiReference @NotNull [] createPlaceholderPropertiesReferences(@NotNull Map<TextRange, PlaceholderInfo> textRanges, @Nullable PsiElement valueElement) {
        TextRange[] ranges;
        if (textRanges == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(13);
        }
        if (valueElement == null || textRanges.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(14);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList references = new SmartList();
        for (TextRange textRange : ranges = textRanges.keySet().toArray(TextRange.EMPTY_ARRAY)) {
            if (PlaceholderUtilsImpl.hasNestedPlaceholders(textRange, ranges)) continue;
            PlaceholderInfo info = textRanges.get(textRange);
            references.add(PlaceholderPropertyReference.create(valueElement, textRange, info));
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(15);
        }
        return psiReferenceArray;
    }

    private static boolean hasNestedPlaceholders(@NotNull TextRange textRange, TextRange ... ranges) {
        if (textRange == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(16);
        }
        for (TextRange range : ranges) {
            if (range.equals((Object)textRange) || !textRange.contains(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Map<TextRange, PlaceholderInfo> getTextRanges(GenericDomValue domValue) {
        THashMap textRanges = new THashMap();
        Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes((PsiElement)domValue.getXmlElement());
        if (prefixes == null) {
            return null;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)domValue);
        if (valueElement == null) {
            return null;
        }
        String text = valueElement.getText();
        for (Pair<String, String> prefixAndSuffix : prefixes) {
            String prefix = (String)prefixAndSuffix.first;
            String suffix = (String)prefixAndSuffix.second;
            for (TextRange fullTextRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefix, (String)suffix, (boolean)true)) {
                TextRange placeholderTextRange = new TextRange(fullTextRange.getStartOffset() + prefix.length(), fullTextRange.getEndOffset() - suffix.length());
                String placeholderText = placeholderTextRange.substring(text);
                textRanges.put(placeholderTextRange, new PlaceholderInfo(placeholderText, prefixAndSuffix, text, fullTextRange));
            }
        }
        return textRanges;
    }

    private Map<TextRange, PlaceholderInfo> getTextRangesWithNested(@NotNull PsiElement element) {
        if (element == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(17);
        }
        THashMap textRanges = new THashMap();
        Set<Pair<String, String>> prefixes = this.getPlaceholderPrefixes(element);
        if (prefixes == null) {
            return Collections.emptyMap();
        }
        for (Pair<String, String> prefixAndSuffix : prefixes) {
            String text = element.getText();
            String prefix = (String)prefixAndSuffix.first;
            String suffix = (String)prefixAndSuffix.second;
            for (TextRange textRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefix, (String)suffix)) {
                String placeholderText = textRange.substring(text);
                textRanges.put(textRange, new PlaceholderInfo(placeholderText, prefixAndSuffix, text, textRange));
            }
        }
        return textRanges;
    }

    private Collection<String> getExpandedVariants(GenericDomValue value) {
        boolean quit;
        String stringValue = value.getRawText();
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(value);
        if (textRanges == null || textRanges.isEmpty()) {
            return ContainerUtil.createMaybeSingletonList((Object)stringValue);
        }
        TextRange[] ranges = PlaceholderUtilsImpl.sortTextRanges(textRanges);
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)value);
        assert (valueElement != null);
        THashSet result = new THashSet();
        ResolveResult[][] variants = new ResolveResult[ranges.length][];
        for (int i = 0; i < ranges.length; ++i) {
            TextRange range = ranges[i];
            PlaceholderInfo info = textRanges.get(range);
            PlaceholderPropertyReference reference = PlaceholderPropertyReference.create((PsiElement)valueElement, range, info);
            ResolveResult[] results = reference.multiResolve(false);
            variants[i] = results;
        }
        int[] indices = new int[ranges.length];
        int offsetBase = -ElementManipulators.getValueTextRange((PsiElement)valueElement).getStartOffset();
        block1: do {
            int offset = offsetBase;
            StringBuilder sb = new StringBuilder(stringValue);
            for (int i = 0; i < indices.length; ++i) {
                IProperty property;
                String replacement;
                ResolveResult resolveResult;
                PsiElement element;
                PlaceholderInfo info = textRanges.get(ranges[i]);
                if (variants[i].length == 0 || !((element = (resolveResult = variants[i][indices[i]]).getElement()) instanceof IProperty) || (replacement = (property = (IProperty)element).getValue()) == null) continue;
                sb.replace(offset + info.fullTextRange.getStartOffset(), offset + info.fullTextRange.getEndOffset(), replacement);
                offset += replacement.length() - info.fullTextRange.getLength();
            }
            result.add((Object)sb.toString());
            quit = true;
            for (int idx = 0; idx < indices.length; ++idx) {
                if (indices[idx] >= variants[idx].length - 1) continue;
                quit = false;
                int n = idx;
                indices[n] = indices[n] + 1;
                for (int i = 0; i < idx; ++i) {
                    indices[i] = 0;
                }
                continue block1;
            }
        } while (!quit);
        return result;
    }

    @Override
    @Nullable
    public String resolvePlaceholders(@NotNull GenericDomValue genericDomValue) {
        String result;
        if (genericDomValue == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)(result = genericDomValue.getRawText()))) {
            return result;
        }
        XmlElement valueElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        assert (valueElement != null);
        Map<TextRange, PlaceholderInfo> textRanges = this.getTextRanges(genericDomValue);
        if (textRanges == null) {
            return result;
        }
        TextRange[] ranges = PlaceholderUtilsImpl.sortTextRanges(textRanges);
        HashMap<String, String> changes = new HashMap<String, String>();
        for (TextRange range : ranges) {
            String strToReplace;
            PlaceholderInfo placeholderInfo = textRanges.get(range);
            String propertyValue = PlaceholderUtilsImpl.getPropertyValue(valueElement, range, placeholderInfo);
            if (propertyValue == null || StringUtil.isEmptyOrSpaces((String)(strToReplace = placeholderInfo.fullTextRange.substring(placeholderInfo.myElementText)))) continue;
            changes.put(strToReplace, propertyValue);
        }
        if (textRanges.size() == changes.size()) {
            for (Map.Entry entry : changes.entrySet()) {
                result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        return result;
    }

    @Nullable
    private static String getPropertyValue(XmlElement valueElement, TextRange range, PlaceholderInfo info) {
        return (String)RecursionManager.doPreventingRecursion((Object)valueElement, (boolean)true, (Computable)((NullableComputable)() -> {
            PsiElement element;
            PlaceholderPropertyReference reference = PlaceholderPropertyReference.create((PsiElement)valueElement, range, info);
            ResolveResult[] results = reference.multiResolve(false);
            if (results.length > 0 && (element = results[0].getElement()) instanceof IProperty) {
                return ((IProperty)element).getValue();
            }
            return reference.getDefaultValue();
        }));
    }

    private static TextRange[] sortTextRanges(@NotNull Map<TextRange, PlaceholderInfo> textRanges) {
        if (textRanges == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(19);
        }
        TextRange[] ranges = textRanges.keySet().toArray(TextRange.EMPTY_ARRAY);
        Arrays.sort(ranges, Comparator.comparingInt(TextRange::getStartOffset));
        return ranges;
    }

    @Nullable
    private Set<Pair<String, String>> getPlaceholderPrefixes(PsiElement context) {
        if (context == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
        }
        if (!PlaceholderUtilsImpl.hasCustomPlaceholderPrefixCandidates(module)) {
            return Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
        }
        PsiFile contextContainingFile = context.getContainingFile();
        return (Set)CachedValuesManager.getCachedValue((PsiElement)contextContainingFile, () -> {
            THashSet prefixes = new THashSet();
            THashSet processed = new THashSet();
            if (contextContainingFile instanceof XmlFile) {
                processed.add(contextContainingFile);
                this.processFile((XmlFile)contextContainingFile, (Set<Pair<String, String>>)prefixes);
            }
            ModuleUtilCore.visitMeAndDependentModules((Module)module, arg_0 -> this.lambda$getPlaceholderPrefixes$3((Set)processed, (Set)prefixes, arg_0));
            return CachedValueProvider.Result.create((Object)prefixes, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean hasCustomPlaceholderPrefixCandidates(@NotNull Module module) {
        Project project;
        if (module == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(20);
        }
        if (DumbService.isDumb((Project)(project = module.getProject()))) {
            return false;
        }
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        Collection springXmlFiles = DomService.getInstance().getDomFileCandidates(Beans.class, moduleScope);
        return !CacheManager.getInstance((Project)project).processFilesWithWord((Processor)new CommonProcessors.FindFirstProcessor(), "placeholderPrefix", (short)255, GlobalSearchScope.filesScope((Project)project, (Collection)springXmlFiles), true);
    }

    private void processFile(XmlFile psiFile, Set<Pair<String, String>> prefixes) {
        Set values = (Set)CachedValuesManager.getManager((Project)psiFile.getProject()).getCachedValue((UserDataHolder)psiFile, PLACEHOLDER_PREFIXES_KEY, () -> new CachedValueProvider.Result(this.getPlaceholderPrefixes(psiFile), new Object[]{psiFile}), false);
        if (values != null) {
            prefixes.addAll(values);
        }
    }

    @NotNull
    private Set<Pair<String, String>> getPlaceholderPrefixes(@NotNull XmlFile configFile) {
        Module module;
        if (configFile == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(21);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)configFile)) == null) {
            Set<Pair<String, String>> set = Collections.emptySet();
            if (set == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(22);
            }
            return set;
        }
        LocalXmlModel springModel = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(configFile, module, Collections.emptySet());
        if (springModel == null) {
            Set<Pair<String, String>> set = Collections.emptySet();
            if (set == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(23);
            }
            return set;
        }
        List<SpringBeanPointer> configurers = springModel.getPlaceholderConfigurerBeans();
        if (configurers.isEmpty()) {
            Set<Pair<String, String>> set = Collections.singleton(DEFAULT_PLACEHOLDER_PAIR);
            if (set == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(24);
            }
            return set;
        }
        HashSet<Pair<String, String>> set = new HashSet<Pair<String, String>>();
        for (SpringBeanPointer configurer : configurers) {
            Object springBean;
            if (!configFile.equals(configurer.getContainingFile()) || !((springBean = configurer.getSpringBean()) instanceof DomSpringBean)) continue;
            set.add(this.getPlaceholderPrefixAndSuffixInner((DomSpringBean)springBean));
        }
        HashSet<Pair<String, String>> hashSet = set;
        if (hashSet == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<String> getValueVariants(@NotNull SpringValueHolderDefinition property) {
        GenericDomValue<?> value;
        if (property == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(26);
        }
        if ((value = SpringPropertyUtils.getPropertyDomValue(property)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        Collection<String> collection = this.getValueVariants(value);
        if (collection == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getValueVariants(GenericDomValue value) {
        String stringValue = value.getStringValue();
        if (StringUtil.isEmpty((String)stringValue)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PlaceholderUtilsImpl.$$$reportNull$$$0(29);
            }
            return list;
        }
        Collection<String> collection = this.getExpandedVariants(value);
        if (collection == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(30);
        }
        return collection;
    }

    private static Collection<PropertiesFile> getResourceFiles(@NotNull PsiElement element, @NotNull String s, String delimiter, Condition<PsiFileSystemItem> filter) {
        if (element == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(31);
        }
        if (s == null) {
            PlaceholderUtilsImpl.$$$reportNull$$$0(32);
        }
        ArrayList references = new ArrayList();
        int startInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        SpringResourcesUtil resourcesUtil = SpringResourcesUtil.getInstance();
        SpringReferenceUtils.processSeparatedString(s, delimiter, (PairProcessor<? super String, ? super Integer>)((PairProcessor)(s1, offset) -> {
            SpringResourcesBuilder builder = SpringResourcesBuilder.create(element, s1).offset(offset + startInElement);
            ContainerUtil.addAll((Collection)references, (Object[])resourcesUtil.getReferences(builder));
            return true;
        }));
        PsiReference[] psiReferences = references.toArray(PsiReference.EMPTY_ARRAY);
        Collection files = resourcesUtil.getResourceItems(psiReferences, filter);
        return ContainerUtil.mapNotNull(files, (Function)((NullableFunction)PropertiesImplUtil::getPropertiesFile));
    }

    private /* synthetic */ boolean lambda$getPlaceholderPrefixes$3(Set processed, Set prefixes, Module module1) {
        SpringFacet facet = SpringFacet.getInstance(module1);
        if (facet != null) {
            Set<SpringFileSet> sets = facet.getFileSets();
            for (SpringFileSet set : sets.toArray(new SpringFileSet[0])) {
                Set<VirtualFilePointer> files = set.getXmlFiles();
                for (VirtualFilePointer pointer : files) {
                    PsiFile psiFile;
                    VirtualFile file = pointer.getFile();
                    if (file == null || !((psiFile = PsiManager.getInstance((Project)module1.getProject()).findFile(file)) instanceof XmlFile) || !processed.add(psiFile)) continue;
                    this.processFile((XmlFile)psiFile, prefixes);
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/PlaceholderUtilsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = LOCATIONS_PROPERTY_NAME;
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixAndSuffix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/PlaceholderUtilsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLocationString";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderPrefixAndSuffixInner";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlaceholderPropertiesReferences";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderPrefixes";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDomValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsDefaultPlaceholderDefinitions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixAndSuffixDefinedCorrectly";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceholderPropertiesReferences";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasNestedPlaceholders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangesWithNested";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlaceholders";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sortTextRanges";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomPlaceholderPrefixCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderPrefixes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getValueVariants";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getResourceFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

