/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;

public final class SpringPropertyUtils {
    @Nullable
    public static GenericDomValue<?> getPropertyDomValue(@NotNull SpringValueHolderDefinition valueHolderDefinition) {
        GenericDomValue<?> valueElement;
        if (valueHolderDefinition == null) {
            SpringPropertyUtils.$$$reportNull$$$0(0);
        }
        return (valueElement = valueHolderDefinition.getValueElement()) != null && valueElement.getStringValue() == null ? null : valueElement;
    }

    @NotNull
    public static Set<String> getArrayPropertyStringValues(@NotNull CommonSpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition propertyDefinition;
        if (bean == null) {
            SpringPropertyUtils.$$$reportNull$$$0(1);
        }
        if (propertyName == null) {
            SpringPropertyUtils.$$$reportNull$$$0(2);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        String value = SpringPropertyUtils.getPropertyStringValue(bean, propertyName);
        if (value != null) {
            set.addAll(SpringCommonUtils.tokenize(value));
        } else if (bean instanceof SpringBean && (propertyDefinition = ((SpringBean)bean).getProperty(propertyName)) instanceof SpringProperty) {
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getList()));
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getSet()));
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getArray()));
        }
        LinkedHashSet<String> linkedHashSet = set;
        if (linkedHashSet == null) {
            SpringPropertyUtils.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> getStringValues(@NotNull CollectionElements elements) {
        if (elements == null) {
            SpringPropertyUtils.$$$reportNull$$$0(4);
        }
        LinkedHashSet<String> strings = new LinkedHashSet<String>();
        for (SpringValue springValue : elements.getValues()) {
            ContainerUtil.addIfNotNull(strings, (Object)springValue.getStringValue());
        }
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            SpringPropertyUtils.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    @Nullable
    public static String getPropertyStringValue(CommonSpringBean bean, String propertyName) {
        PsiClass beanClass;
        if (bean instanceof SpringBean) {
            SpringPropertyDefinition property = ((SpringBean)bean).getProperty(propertyName);
            return property == null ? null : property.getValueAsString();
        }
        if (bean instanceof ContextJavaBean && (beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType())) != null) {
            Set<UExpression> uastExpressions;
            PsiMethod setter;
            PsiMethod byMethodReturnTypeBeanClass = PropertyUtilBase.findPropertySetter((PsiClass)beanClass, (String)propertyName, (boolean)false, (boolean)true);
            PsiMethod psiMethod = setter = byMethodReturnTypeBeanClass == null ? PropertyUtilBase.findPropertySetter((PsiClass)PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true)), (String)propertyName, (boolean)false, (boolean)true) : byMethodReturnTypeBeanClass;
            if (setter != null && !(uastExpressions = SpringCommonUtils.findParameterExpressionInMethodCalls(setter, 0, (SearchScope)new LocalSearchScope((PsiElement)((ContextJavaBean)bean).getPsiElement()))).isEmpty()) {
                return SpringCommonUtils.evaluateStringExpression(uastExpressions.iterator().next());
            }
        }
        return null;
    }

    @NotNull
    public static Set<String> getListOrSetValues(@NotNull SpringElementsHolder elementsHolder) {
        if (elementsHolder == null) {
            SpringPropertyUtils.$$$reportNull$$$0(6);
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getList())) {
            return SpringPropertyUtils.getValues(elementsHolder.getList());
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getSet())) {
            return SpringPropertyUtils.getValues(elementsHolder.getSet());
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getArray())) {
            return SpringPropertyUtils.getValues(elementsHolder.getArray());
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SpringPropertyUtils.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public static Set<String> getValues(@NotNull ListOrSet listOrSet) {
        if (listOrSet == null) {
            SpringPropertyUtils.$$$reportNull$$$0(8);
        }
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        for (SpringValue value : listOrSet.getValues()) {
            ContainerUtil.addIfNotNull(values, (Object)value.getStringValue());
        }
        LinkedHashSet<String> linkedHashSet = values;
        if (linkedHashSet == null) {
            SpringPropertyUtils.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    public static PsiArrayType getArrayType(@NotNull ListOrSet array) {
        PsiClass psiClass;
        if (array == null) {
            SpringPropertyUtils.$$$reportNull$$$0(10);
        }
        if ((psiClass = (PsiClass)array.getValueType().getValue()) != null) {
            return PsiTypesUtil.getClassType((PsiClass)psiClass).createArrayType();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)array.getManager().getProject());
        return PsiType.getJavaLangObject((PsiManager)array.getXmlTag().getManager(), (GlobalSearchScope)scope).createArrayType();
    }

    public static boolean isSpecificProperty(@NotNull GenericDomValue value, @NotNull String propertyName, String ... classNames) {
        SpringBean bean;
        SpringProperty springProperty;
        if (value == null) {
            SpringPropertyUtils.$$$reportNull$$$0(11);
        }
        if (propertyName == null) {
            SpringPropertyUtils.$$$reportNull$$$0(12);
        }
        if (classNames == null) {
            SpringPropertyUtils.$$$reportNull$$$0(13);
        }
        if ((springProperty = (SpringProperty)value.getParentOfType(SpringProperty.class, false)) != null && propertyName.equals(springProperty.getPropertyName()) && (bean = (SpringBean)springProperty.getParentOfType(SpringBean.class, false)) != null) {
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true));
            if (beanClass == null) {
                return false;
            }
            for (String className : classNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)className)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static SpringPropertyDefinition findPropertyByName(@NotNull CommonSpringBean bean, @NotNull String propertyName) {
        if (bean == null) {
            SpringPropertyUtils.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            SpringPropertyUtils.$$$reportNull$$$0(15);
        }
        return bean.isValid() && bean instanceof SpringBean ? ((SpringBean)bean).getProperty(propertyName) : null;
    }

    public static List<SpringValueHolderDefinition> getValueHolders(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            SpringPropertyUtils.$$$reportNull$$$0(16);
        }
        return bean instanceof DomSpringBean ? DomUtil.getDefinedChildrenOfType((DomElement)((DomElement)bean), SpringValueHolderDefinition.class) : Collections.emptyList();
    }

    public static List<SpringPropertyDefinition> getProperties(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            SpringPropertyUtils.$$$reportNull$$$0(17);
        }
        return bean instanceof DomSpringBean ? DomUtil.getDefinedChildrenOfType((DomElement)((DomElement)bean), SpringPropertyDefinition.class) : Collections.emptyList();
    }

    public static List<SpringBeanPointer> getSpringValueHolderDependencies(SpringValueHolderDefinition valueHolder) {
        return new ArrayList<SpringBeanPointer>(SpringPropertyUtils.getValueHolderDependencies(valueHolder).keySet());
    }

    public static Map<SpringBeanPointer, DomElement> getValueHolderDependencies(SpringValueHolderDefinition valueHolder) {
        LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
        SpringPropertyUtils.addValueHolder(valueHolder, beans);
        return beans;
    }

    private static void addValueHolder(SpringValueHolderDefinition definition, Map<SpringBeanPointer, DomElement> beans) {
        GenericDomValue<SpringBeanPointer> element = definition.getRefElement();
        if (element != null) {
            SpringPropertyUtils.addBasePointer(element, beans);
        }
        if (definition instanceof SpringValueHolder) {
            SpringBean innerBean;
            SpringValueHolder valueHolder = (SpringValueHolder)definition;
            SpringPropertyUtils.addSpringRefBeans(valueHolder.getRef(), beans);
            SpringPropertyUtils.addIdrefBeans(valueHolder.getIdref(), beans);
            SpringPropertyUtils.processCollections(beans, valueHolder);
            if (DomUtil.hasXml((DomElement)valueHolder.getMap())) {
                SpringPropertyUtils.addMapReferences(valueHolder.getMap(), beans);
            }
            if (DomUtil.hasXml((DomElement)(innerBean = valueHolder.getBean()))) {
                beans.put(BeanService.getInstance().createSpringBeanPointer(innerBean), innerBean);
            }
        }
    }

    private static void processCollections(Map<SpringBeanPointer, DomElement> beans, SpringValueHolder valueHolder) {
        List listOrSets = DomUtil.getChildrenOfType((DomElement)valueHolder, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            DomElement domElement = listOrSet.getManager().getDomElement(listOrSet.getXmlTag());
            if (domElement instanceof DomSpringBean) {
                beans.put(BeanService.getInstance().createSpringBeanPointer((DomSpringBean)domElement), domElement);
                continue;
            }
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
    }

    private static void addBasePointer(@NotNull GenericDomValue<SpringBeanPointer> value, Map<SpringBeanPointer, DomElement> beans) {
        SpringBeanPointer beanPointer;
        if (value == null) {
            SpringPropertyUtils.$$$reportNull$$$0(18);
        }
        if ((beanPointer = (SpringBeanPointer)value.getValue()) == null) {
            return;
        }
        SpringBeanPointer basePointer = beanPointer.getBasePointer();
        beans.put(basePointer, (DomElement)value);
    }

    private static void addMapReferences(SpringMap map, Map<SpringBeanPointer, DomElement> beans) {
        for (SpringEntry entry : map.getEntries()) {
            SpringPropertyUtils.addValueHolder(entry, beans);
        }
    }

    private static void addIdrefBeans(Idref idref, Map<SpringBeanPointer, DomElement> beans) {
        SpringPropertyUtils.addBasePointer(idref.getLocal(), beans);
        SpringPropertyUtils.addBasePointer(idref.getBean(), beans);
    }

    private static void addSpringRefBeans(SpringRef springRef, Map<SpringBeanPointer, DomElement> beans) {
        if (DomUtil.hasXml((DomElement)springRef)) {
            SpringPropertyUtils.addBasePointer(springRef.getBean(), beans);
            SpringPropertyUtils.addBasePointer(springRef.getLocal(), beans);
        }
    }

    public static void addCollectionReferences(CollectionElements elements, Map<SpringBeanPointer, DomElement> beans) {
        for (SpringRef springRef : elements.getRefs()) {
            SpringPropertyUtils.addSpringRefBeans(springRef, beans);
        }
        for (Idref idref : elements.getIdrefs()) {
            SpringPropertyUtils.addIdrefBeans(idref, beans);
        }
        for (ListOrSet listOrSet : elements.getLists()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (ListOrSet listOrSet : elements.getSets()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (ListOrSet listOrSet : elements.getArrays()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (SpringBean innerBean : elements.getBeans()) {
            beans.put(BeanService.getInstance().createSpringBeanPointer(innerBean), innerBean);
        }
        for (SpringMap map : elements.getMaps()) {
            SpringPropertyUtils.addMapReferences(map, beans);
        }
    }

    public static List<SpringBeanPointer> getCollectionElementDependencies(CollectionElements collectionElements) {
        LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
        SpringPropertyUtils.addCollectionReferences(collectionElements, beans);
        return new ArrayList<SpringBeanPointer>(beans.keySet());
    }

    public static boolean processSpringValues(SpringProperty property, PairProcessor<? super GenericDomValue, ? super String> processor2) {
        GenericAttributeValue<String> valueAttr = property.getValueAttr();
        XmlAttribute valueAttrElement = valueAttr.getXmlAttribute();
        String valueAttrString = valueAttr.getStringValue();
        if (valueAttrElement != null && valueAttrString != null && !processor2.process(valueAttr, (Object)valueAttrString)) {
            return false;
        }
        SpringValue value = property.getValue();
        XmlTag valueElement = value.getXmlTag();
        String valueString = value.getStringValue();
        if (valueElement != null && valueString != null && !processor2.process((Object)value, (Object)valueString)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getList(), processor2)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getSet(), processor2)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getArray(), processor2)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringPointerValue(property.getRefAttr(), processor2)) {
            return false;
        }
        return SpringPropertyUtils.processSpringPointerValue(property.getRef().getBean(), processor2);
    }

    private static boolean processSpringPointerValue(GenericAttributeValue<SpringBeanPointer> pointerValue, PairProcessor<? super GenericDomValue, ? super String> processor2) {
        CommonSpringBean bean;
        SpringBeanPointer pointer = (SpringBeanPointer)pointerValue.getValue();
        CommonSpringBean commonSpringBean = bean = pointer == null ? null : (CommonSpringBean)pointer.getSpringBean();
        if (bean instanceof ListOrSet) {
            if (!SpringPropertyUtils.processSpringListOrSetValues((ListOrSet)((Object)bean), processor2)) {
                return false;
            }
        } else if (bean != null) {
            SpringPropertyDefinition value = SpringPropertyUtils.findPropertyByName(bean, "sourceList");
            if (value == null) {
                value = SpringPropertyUtils.findPropertyByName(bean, "sourceSet");
            }
            if (value instanceof SpringProperty && !SpringPropertyUtils.processSpringListOrSetValues(((SpringProperty)value).getList(), processor2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processSpringListOrSetValues(ListOrSet listOrSet, PairProcessor<? super GenericDomValue, ? super String> processor2) {
        for (SpringValue springValue : listOrSet.getValues()) {
            XmlTag element = springValue.getXmlTag();
            String string = springValue.getStringValue();
            if (element == null || string == null || processor2.process((Object)springValue, (Object)string)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static SpringBeanPointer findReferencedBean(@NotNull SpringPropertyDefinition definition) {
        SpringBeanPointer springBeanPointer;
        if (definition == null) {
            SpringPropertyUtils.$$$reportNull$$$0(19);
        }
        if ((springBeanPointer = definition.getRefValue()) != null) {
            return springBeanPointer;
        }
        return definition instanceof SpringInjection ? SpringPropertyUtils.findReferencedBean((SpringInjection)((Object)definition)) : null;
    }

    @Nullable
    public static SpringBeanPointer findReferencedBean(@NotNull SpringInjection injection) {
        SpringBeanPointer refAttrPointer;
        if (injection == null) {
            SpringPropertyUtils.$$$reportNull$$$0(20);
        }
        if ((refAttrPointer = (SpringBeanPointer)injection.getRefAttr().getValue()) != null) {
            return refAttrPointer;
        }
        if (DomUtil.hasXml((DomElement)injection.getRef())) {
            SpringRef springRef = injection.getRef();
            SpringBeanPointer beanPointer = (SpringBeanPointer)springRef.getBean().getValue();
            if (beanPointer != null) {
                return beanPointer;
            }
            SpringBeanPointer localPointer = (SpringBeanPointer)springRef.getLocal().getValue();
            if (localPointer != null) {
                return localPointer;
            }
            SpringBeanPointer parentPointer = (SpringBeanPointer)springRef.getParentAttr().getValue();
            if (parentPointer != null) {
                return parentPointer;
            }
        } else if (DomUtil.hasXml((DomElement)injection.getBean())) {
            return BeanService.getInstance().createSpringBeanPointer(injection.getBean());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHolderDefinition";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 2: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringPropertyUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOrSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNames";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringPropertyUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayPropertyStringValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValues";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getListOrSetValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDomValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArrayPropertyStringValues";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getListOrSetValues";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArrayType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSpecificProperty";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyByName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValueHolders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addBasePointer";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

