/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.ExplicitRedefinitionAwareBeansCollector;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModelSearchers {
    @NotNull
    public static List<SpringBeanPointer> findBeans(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(1);
        }
        if (!parameters.canSearch()) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringModelSearchers.$$$reportNull$$$0(2);
            }
            return list;
        }
        ExplicitRedefinitionAwareBeansCollector processor2 = new ExplicitRedefinitionAwareBeansCollector();
        model.processByClass(parameters, processor2);
        return new ArrayList<SpringBeanPointer>(processor2.getResult());
    }

    @Nullable
    public static SpringBeanPointer findBean(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(3);
        }
        if (beanName == null) {
            SpringModelSearchers.$$$reportNull$$$0(4);
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor2 = new CommonProcessors.FindFirstProcessor();
        model.processByName(SpringModelSearchParameters.byName(beanName), (Processor<SpringBeanPointer>)findFirstProcessor2);
        return (SpringBeanPointer)findFirstProcessor2.getFoundValue();
    }

    @NotNull
    public static Collection<SpringBeanPointer> findBeans(@NotNull CommonSpringModel model, @NotNull String beanName) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(5);
        }
        if (beanName == null) {
            SpringModelSearchers.$$$reportNull$$$0(6);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        model.processByName(SpringModelSearchParameters.byName(beanName), (Processor<SpringBeanPointer>)collectProcessor);
        Collection collection = collectProcessor.getResults();
        if (collection == null) {
            SpringModelSearchers.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(9);
        }
        return SpringModelSearchers.containsBean(model, parameters);
    }

    public static boolean doesBeanExist(@NotNull CommonSpringModel model, @NotNull PsiClass beanClass) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(10);
        }
        if (beanClass == null) {
            SpringModelSearchers.$$$reportNull$$$0(11);
        }
        return SpringModelSearchers.containsBean(model, SpringModelSearchParameters.byClass(beanClass).withInheritors().effectiveBeanTypes());
    }

    private static boolean containsBean(@NotNull CommonSpringModel model, @NotNull SpringModelSearchParameters.BeanClass parameters) {
        if (model == null) {
            SpringModelSearchers.$$$reportNull$$$0(12);
        }
        if (parameters == null) {
            SpringModelSearchers.$$$reportNull$$$0(13);
        }
        if (!parameters.canSearch()) {
            return false;
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor2 = new CommonProcessors.FindFirstProcessor();
        model.processByClass(parameters, (Processor<SpringBeanPointer>)findFirstProcessor2);
        return findFirstProcessor2.isFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringModelSearchers";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringModelSearchers";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBeans";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findBeans";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBean";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doesBeanExist";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsBean";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

