/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringSchemaVersion;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringCommonUtils {
    public static final String SPRING_DELIMITERS = ",; ";
    public static final CharFilter ourFilter = ch -> SPRING_DELIMITERS.indexOf(ch) >= 0;

    private SpringCommonUtils() {
    }

    public static List<String> tokenize(@NotNull String str) {
        if (str == null) {
            SpringCommonUtils.$$$reportNull$$$0(0);
        }
        return SpringCommonUtils.tokenize(str, SPRING_DELIMITERS);
    }

    @NotNull
    public static List<String> tokenize(@NotNull String str, @NotNull String delimiters) {
        if (str == null) {
            SpringCommonUtils.$$$reportNull$$$0(1);
        }
        if (delimiters == null) {
            SpringCommonUtils.$$$reportNull$$$0(2);
        }
        SmartList list = new SmartList();
        StringTokenizer st = new StringTokenizer(str, delimiters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            list.add(token);
        }
        SmartList smartList = list;
        if (smartList == null) {
            SpringCommonUtils.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            SmartList generics = new SmartList();
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
            SmartList smartList = generics;
            if (smartList == null) {
                SpringCommonUtils.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            SpringCommonUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean hasSpringFacets(@NotNull Project project) {
        if (project == null) {
            SpringCommonUtils.$$$reportNull$$$0(6);
        }
        return ProjectFacetManager.getInstance((Project)project).hasFacets(SpringFacet.FACET_TYPE_ID);
    }

    public static boolean hasSpringFacet(@Nullable Module module) {
        return module != null && SpringFacet.getInstance(module) != null;
    }

    public static boolean isConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(7);
        }
        return SpringCommonUtils.isSpringBeanCandidateClass(psiClass) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.context.annotation.Configuration", (int)0);
    }

    public static boolean isConfigurationOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(8);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null;
    }

    public static boolean isComponentOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(9);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META}) != null;
    }

    public static boolean isStereotypeComponentOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(10);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    @Contract(value="null->false")
    public static boolean isSpringBeanCandidateClass(@Nullable PsiClass psiClass) {
        return psiClass != null && psiClass.isValid() && !(psiClass instanceof PsiTypeParameter) && !psiClass.hasModifierProperty("private") && !psiClass.isAnnotationType() && psiClass.getQualifiedName() != null && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    public static PsiElement createSpringXmlConfigFile(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        FileTemplate template = SpringCommonUtils.getSpringXmlTemplate(module);
        Object fileName = FileUtilRt.getExtension((String)newName).length() == 0 ? newName + ".xml" : newName;
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
    }

    public static FileTemplate getSpringXmlTemplate(Module ... modules) {
        for (Module module : modules) {
            String version = JarVersionDetectionUtil.detectJarVersion((String)"org.springframework.core.SpringVersion", (Module)module);
            if (version == null) continue;
            return version.startsWith("1") ? SpringSchemaVersion.SPRING_1_DTD.getTemplate(module.getProject()) : SpringSchemaVersion.SPRING_SCHEMA.getTemplate(module.getProject());
        }
        return SpringSchemaVersion.SPRING_SCHEMA.getTemplate(modules[0].getProject());
    }

    @Contract(value="null -> false")
    public static boolean isSpringConfigured(@Nullable Module module) {
        if (module != null) {
            if (SpringCommonUtils.hasSpringFacet(module)) {
                return true;
            }
            for (Module dependent : ModuleUtilCore.getAllDependentModules((Module)module)) {
                if (!SpringCommonUtils.hasSpringFacet(dependent)) continue;
                return true;
            }
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            for (Module dependency : dependencies) {
                if (!SpringCommonUtils.hasSpringFacet(dependency)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean isSpringBeanCandidateClassInSpringProject(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (!SpringCommonUtils.hasSpringFacets(psiClass.getProject())) {
            return false;
        }
        if (!SpringLibraryUtil.hasSpringLibrary(psiClass.getProject())) {
            return false;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (SpringCommonUtils.isSpringEnabledModule(module)) {
            return true;
        }
        return module == null;
    }

    public static boolean isSpringEnabledModule(@Nullable Module module) {
        return SpringCommonUtils.isSpringConfigured(module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module);
    }

    public static boolean isInSpringEnabledModule(@Nullable UElement uElement) {
        PsiElement psi = UElementKt.getSourcePsiElement((UElement)uElement);
        if (psi == null) {
            return false;
        }
        return SpringCommonUtils.isSpringEnabledModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psi));
    }

    @Nullable
    public static GlobalSearchScope getConfigFilesScope(Project project, GlobalSearchScope scope) {
        PsiPackage metaInfPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metaInfPackage == null) {
            return null;
        }
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)metaInfPackage, (boolean)false);
        return scope.intersectWith(packageScope);
    }

    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(Module module, boolean withTests, String filename, Class<T> psiFileType) {
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)withTests);
        return SpringCommonUtils.findConfigFilesInMetaInf(module.getProject(), moduleScope, filename, psiFileType);
    }

    @NotNull
    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(Project project, GlobalSearchScope scope, String filename, Class<T> psiFileType) {
        GlobalSearchScope searchScope = SpringCommonUtils.getConfigFilesScope(project, scope);
        if (searchScope == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(11);
            }
            return list;
        }
        Object[] configFiles = FilenameIndex.getFilesByName((Project)project, (String)filename, (GlobalSearchScope)searchScope);
        if (configFiles.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = ContainerUtil.findAll((Object[])configFiles, psiFileType);
        if (list == null) {
            SpringCommonUtils.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static PsiClass findLibraryClass(@Nullable Module module, @NotNull String className) {
        if (className == null) {
            SpringCommonUtils.$$$reportNull$$$0(14);
        }
        if (module == null || module.isDisposed()) {
            return null;
        }
        Project project = module.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> SpringCommonUtils.findLibraryClass(project, key, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)));
            return CachedValueProvider.Result.createSingleDependency((Object)map, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiClass)cache.get(className);
    }

    @Nullable
    private static PsiClass findLibraryClass(@NotNull Project project, @NotNull String fqn, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            SpringCommonUtils.$$$reportNull$$$0(15);
        }
        if (fqn == null) {
            SpringCommonUtils.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            SpringCommonUtils.$$$reportNull$$$0(17);
        }
        return (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> JavaPsiFacade.getInstance((Project)project).findClass(fqn, searchScope));
    }

    @NotNull
    public static Set<UExpression> findParameterExpressionInMethodCalls(@NotNull PsiMethod psiMethod, int forParam, @Nullable SearchScope searchScope) {
        if (psiMethod == null) {
            SpringCommonUtils.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            Set<UExpression> set = Collections.emptySet();
            if (set == null) {
                SpringCommonUtils.$$$reportNull$$$0(19);
            }
            return set;
        }
        Set<UExpression> set = SpringCommonUtils.findMethodCalls(psiMethod, searchScope).stream().map(uCallExpression -> uCallExpression.getArgumentForParameter(forParam)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    private static Set<UCallExpression> findMethodCalls(@NotNull PsiMethod psiMethod, @Nullable SearchScope searchScope) {
        if (psiMethod == null) {
            SpringCommonUtils.$$$reportNull$$$0(21);
        }
        Set<UCallExpression> set = MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).findAll().stream().map(ref -> (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)ref.getElement(), UCallExpression.class)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Nullable
    public static String evaluateStringExpression(@Nullable UExpression expression) {
        Pair pair;
        PsiElement sourcePsi;
        if (expression == null) {
            return null;
        }
        String evaluateString = UastUtils.evaluateString((UExpression)expression);
        if (evaluateString == null && (sourcePsi = expression.getSourcePsi()) instanceof PsiExpression && (pair = StringExpressionHelper.evaluateExpression((PsiElement)sourcePsi)) != null) {
            return (String)pair.second;
        }
        return evaluateString;
    }

    @NotNull
    public static BeanTypeProvider getBeanTypeProvider(Class<? extends BeanTypeProvider> providerClass) {
        BeanTypeProvider beanTypeProvider;
        try {
            beanTypeProvider = providerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + providerClass, e);
        }
        if (beanTypeProvider == null) {
            SpringCommonUtils.$$$reportNull$$$0(23);
        }
        return beanTypeProvider;
    }

    @NotNull
    public static BeanNameProvider getBeanNameProvider(Class<? extends BeanNameProvider> providerClass) {
        BeanNameProvider beanNameProvider;
        try {
            beanNameProvider = providerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + providerClass, e);
        }
        if (beanNameProvider == null) {
            SpringCommonUtils.$$$reportNull$$$0(24);
        }
        return beanNameProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringCommonUtils";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringCommonUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenerics";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigFilesInMetaInf";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findParameterExpressionInMethodCalls";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodCalls";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanTypeProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanNameProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringFacets";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationOrMeta";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isComponentOrMeta";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isStereotypeComponentOrMeta";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findParameterExpressionInMethodCalls";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findMethodCalls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

