/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReferenceHelper;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.jam.utils.SpringResourceLocationsUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'H\u0002\u00a8\u0006("}, d2={"Lcom/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkContextConfiguration", "", "contextConfiguration", "Lcom/intellij/spring/model/jam/testContexts/ContextConfiguration;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "findContextXmlTargets", "", "Lcom/intellij/codeInsight/daemon/quickFix/TargetDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "containingFile", "Lcom/intellij/psi/PsiFile;", "getTestingSqlConfig", "Lcom/intellij/spring/model/jam/testContexts/jdbc/SpringTestingSqlConfig;", "psiClass", "Lcom/intellij/psi/PsiClass;", "hasInnerConfigurations", "configuration", "isLocationsAttributesDefined", "isLocationsAttributesDefinedInHierarchy", "isTargetDirectory", "tc", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileTargetContext;", "processConfigurationsHierarchy", "processor", "Lcom/intellij/util/Processor;", "intellij.spring.core"})
public final class SpringContextConfigurationInspection
extends SpringUastInspectionBase {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        SpringTestingSqlConfig sqlConfig;
        SpringTransactionConfiguration transactionConfiguration;
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UElement uElement = uClass.getUastAnchor();
        if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        UElement nameIdentifier = uElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiClass)) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        ContextConfiguration contextConfiguration = (ContextConfiguration)jamService.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass);
        if (contextConfiguration != null) {
            this.checkContextConfiguration(contextConfiguration, holder);
        }
        if ((transactionConfiguration = (SpringTransactionConfiguration)SpringTransactionConfiguration.META.getJamElement((PsiModifierListOwner)psiClass)) != null) {
            SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, transactionConfiguration.getTransactionManagerAttributeElement());
        }
        if ((sqlConfig = this.getTestingSqlConfig(psiClass)) != null) {
            SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, sqlConfig.getTransactionManagerElement());
            SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, sqlConfig.getDatasourceAttrElement());
        }
        return holder.getResultsArray();
    }

    private final SpringTestingSqlConfig getTestingSqlConfig(PsiClass psiClass) {
        SpringTestingSql testingSql;
        SpringTestingSqlConfig sqlConfig = (SpringTestingSqlConfig)SpringTestingSqlConfig.META.getJamElement((PsiModifierListOwner)psiClass);
        if (sqlConfig != null) {
            return sqlConfig;
        }
        SpringTestingSql springTestingSql = testingSql = (SpringTestingSql)SpringTestingSql.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        return springTestingSql != null ? springTestingSql.getSqlConfig() : null;
    }

    private final void checkContextConfiguration(ContextConfiguration contextConfiguration, ProblemsHolder holder) {
        PsiAnnotation annotation;
        XmlFile xmlFile;
        if (this.isLocationsAttributesDefinedInHierarchy(contextConfiguration)) {
            Iterator<JamStringAttributeElement<List<XmlFile>>> iterator = contextConfiguration.getLocationElements().iterator();
            while (iterator.hasNext()) {
                JamStringAttributeElement<List<XmlFile>> attributeElement;
                JamStringAttributeElement<List<XmlFile>> jamStringAttributeElement = attributeElement = iterator.next();
                Intrinsics.checkNotNullExpressionValue(jamStringAttributeElement, (String)"attributeElement");
                SpringResourceLocationsUtil.INSTANCE.checkResourceLocation(holder, jamStringAttributeElement);
            }
        } else if (SpringTestContextUtilImpl.isGenericXmlContextLoader(contextConfiguration) && (xmlFile = SpringTestContextUtilImpl.getDefaultLocation(contextConfiguration)) == null) {
            PsiAnnotation psiAnnotation = contextConfiguration.getAnnotation();
            Intrinsics.checkNotNull((Object)psiAnnotation);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"contextConfiguration.annotation!!");
            annotation = psiAnnotation;
            PsiFile psiFile = annotation.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"annotation.containingFile");
            PsiDirectory directory = psiFile.getContainingDirectory();
            String newContextFileName = SpringTestContextUtilImpl.getDefaultAppContextName(contextConfiguration);
            LocalQuickFix fix2 = null;
            if (directory != null) {
                Project project = holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                PsiFile psiFile2 = annotation.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"annotation.containingFile");
                List<TargetDirectory> directories = this.findContextXmlTargets(project, psiFile2);
                fix2 = (LocalQuickFix)new CreateFilePathFix((PsiElement)annotation, new NewFileLocation(directories, newContextFileName), (Supplier)new Supplier<String>(annotation){
                    final /* synthetic */ PsiAnnotation $annotation;

                    public final String get() {
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$annotation));
                        Intrinsics.checkNotNull((Object)module);
                        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026rPsiElement(annotation)!!");
                        Module module2 = module;
                        FileTemplate fileTemplate = SpringCommonUtils.getSpringXmlTemplate(module2);
                        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"SpringCommonUtils.getSpringXmlTemplate(module)");
                        return fileTemplate.getText();
                    }
                    {
                        this.$annotation = psiAnnotation;
                    }
                });
            }
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", newContextFileName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix2});
        }
        if (SpringTestContextUtilImpl.isAnnotationConfigLoader(contextConfiguration)) {
            CommonProcessors.FindProcessor<ContextConfiguration> processor2 = new CommonProcessors.FindProcessor<ContextConfiguration>(){

                protected boolean accept(@NotNull ContextConfiguration cc) {
                    Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
                    return cc.getConfigurationClasses().size() != 0;
                }
            };
            this.processConfigurationsHierarchy(contextConfiguration, (Processor<ContextConfiguration>)((Processor)processor2));
            if (!processor2.isFound() && !this.hasInnerConfigurations(contextConfiguration)) {
                PsiAnnotation psiAnnotation = contextConfiguration.getAnnotation();
                Intrinsics.checkNotNull((Object)psiAnnotation);
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"contextConfiguration.annotation!!");
                annotation = psiAnnotation;
                PsiClass psiClass = contextConfiguration.getPsiElement();
                if (psiClass == null) {
                    return;
                }
                PsiClass aClass = psiClass;
                LocalQuickFix fix3 = new LocalQuickFix(aClass){
                    final /* synthetic */ PsiClass $aClass;

                    @NotNull
                    public String getFamilyName() {
                        String string = SpringBundle.message("SpringContextConfigurationInspection.create.nested.configuration.class", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpringBundle.message(\"Sp\u2026ted.configuration.class\")");
                        return string;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        PsiClass existedClass = this.$aClass.findInnerClassByName("ContextConfiguration", false);
                        if (existedClass != null) {
                            PsiModifierList psiModifierList = existedClass.getModifierList();
                            if (psiModifierList != null) {
                                psiModifierList.addAnnotation("org.springframework.context.annotation.Configuration");
                            }
                        } else {
                            PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)this.$aClass.getProject()).createClass("ContextConfiguration");
                            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"JavaPsiFacade.getElement\u2026EXT_CONFIGURATION_SUFFIX)");
                            PsiClass innerClass = psiClass;
                            PsiModifierList modifierList = innerClass.getModifierList();
                            if (modifierList != null) {
                                modifierList.setModifierProperty("public", true);
                                modifierList.setModifierProperty("static", true);
                                modifierList.addAnnotation("org.springframework.context.annotation.Configuration");
                            }
                            this.$aClass.add((PsiElement)innerClass);
                        }
                    }
                    {
                        this.$aClass = $captured_local_variable$0;
                    }
                };
                holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", Intrinsics.stringPlus((String)aClass.getName(), (Object)"ContextConfiguration")), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)(holder.isOnTheFly() ? fix3 : null)});
            }
        }
    }

    private final List<TargetDirectory> findContextXmlTargets(Project project, PsiFile containingFile) {
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile != null) {
            PsiFileReferenceHelper psiFileReferenceHelper = PsiFileReferenceHelper.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)psiFileReferenceHelper, (String)"PsiFileReferenceHelper.getInstance()");
            PsiFileReferenceHelper helper = psiFileReferenceHelper;
            if (helper.isMine(project, virtualFile)) {
                ArrayList<TargetDirectory> directories = new ArrayList<TargetDirectory>();
                Collection collection = helper.getTargetContexts(project, virtualFile, false);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"helper.getTargetContexts\u2026ject, virtualFile, false)");
                Collection targetContexts = collection;
                Iterator iterator = targetContexts.iterator();
                while (iterator.hasNext()) {
                    FileTargetContext tc;
                    FileTargetContext fileTargetContext = tc = (FileTargetContext)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)fileTargetContext, (String)"tc");
                    if (!this.isTargetDirectory(fileTargetContext)) continue;
                    PsiFileSystemItem psiFileSystemItem = tc.getFileSystemItem();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFileSystemItem, (String)"tc.fileSystemItem");
                    PsiManager psiManager = psiFileSystemItem.getManager();
                    PsiFileSystemItem psiFileSystemItem2 = tc.getFileSystemItem();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFileSystemItem2, (String)"tc.fileSystemItem");
                    PsiDirectory directory = psiManager.findDirectory(psiFileSystemItem2.getVirtualFile());
                    if (directory == null) continue;
                    directories.add(new TargetDirectory(directory, tc.getPathToCreate()));
                }
                Collection collection2 = directories;
                boolean bl = false;
                if (!collection2.isEmpty()) {
                    return directories;
                }
            }
        }
        return CollectionsKt.listOf((Object)new TargetDirectory(containingFile.getContainingDirectory()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTargetDirectory(FileTargetContext tc) {
        PsiFileSystemItem context;
        PsiFileSystemItem psiFileSystemItem = context = tc.getFileSystemItem();
        Intrinsics.checkNotNullExpressionValue((Object)psiFileSystemItem, (String)"context");
        if (psiFileSystemItem.getVirtualFile() == null) return false;
        if (!context.isDirectory()) return false;
        if (!context.isValid()) return false;
        VirtualFile virtualFile = context.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"context.virtualFile");
        if (!virtualFile.isInLocalFileSystem()) return false;
        return true;
    }

    private final boolean hasInnerConfigurations(ContextConfiguration configuration) {
        PsiClass psiClass = configuration.getPsiElement();
        if (psiClass == null) {
            return false;
        }
        PsiClass configurationClass = psiClass;
        for (PsiClass psiClass2 : configurationClass.getAllInnerClasses()) {
            if (!psiClass2.hasModifierProperty("static")) continue;
            PsiClass psiClass3 = psiClass2;
            Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"psiClass");
            if (JamService.getJamService((Project)psiClass3.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass2) == null) continue;
            return true;
        }
        return false;
    }

    private final boolean isLocationsAttributesDefined(ContextConfiguration contextConfiguration) {
        return contextConfiguration.hasLocationsAttribute() || contextConfiguration.hasValueAttribute();
    }

    private final boolean isLocationsAttributesDefinedInHierarchy(ContextConfiguration contextConfiguration) {
        CommonProcessors.FindProcessor<ContextConfiguration> searchLocationsProcessor2 = new CommonProcessors.FindProcessor<ContextConfiguration>(this){
            final /* synthetic */ SpringContextConfigurationInspection this$0;

            protected boolean accept(@NotNull ContextConfiguration cc) {
                Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
                return SpringContextConfigurationInspection.access$isLocationsAttributesDefined(this.this$0, cc);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.processConfigurationsHierarchy(contextConfiguration, (Processor<ContextConfiguration>)((Processor)searchLocationsProcessor2));
        return searchLocationsProcessor2.isFound();
    }

    private final boolean processConfigurationsHierarchy(ContextConfiguration contextConfiguration, Processor<ContextConfiguration> processor2) {
        if (!processor2.process((Object)contextConfiguration)) {
            return false;
        }
        PsiClass psiClass = contextConfiguration.getPsiElement();
        if (psiClass != null) {
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            for (PsiClass superClass = psiClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                SpringContextConfiguration configuration = (SpringContextConfiguration)service.getJamElement((PsiElement)superClass, new JamMemberMeta[]{(JamMemberMeta)SpringContextConfiguration.META});
                if (configuration == null || processor2.process((Object)configuration)) continue;
                return false;
            }
        }
        return true;
    }

    public SpringContextConfigurationInspection() {
        super(Reflection.getOrCreateKotlinClass(UClass.class));
    }

    public static final /* synthetic */ boolean access$isLocationsAttributesDefined(SpringContextConfigurationInspection $this, ContextConfiguration contextConfiguration) {
        return $this.isLocationsAttributesDefined(contextConfiguration);
    }
}

