/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.spring.model.jam.converters.SpringAntPatternPackageReferenceSet;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJamConverter
extends JamConverter<Collection<PsiPackage>> {
    public Collection<PsiPackage> fromString(@Nullable String s, JamStringAttributeElement<Collection<PsiPackage>> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return this.calculatePackagesOnFakeElement(s, (PsiElement)context.getPsiElement());
        }
        return this.createReferenceSet(psiLiteral, s).resolvePackage();
    }

    @Nullable
    private Collection<PsiPackage> calculatePackagesOnFakeElement(@NotNull String s, @Nullable PsiElement context) {
        if (s == null) {
            PackageJamConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            return null;
        }
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText("\"" + s + "\"", context);
        if (psiExpression instanceof PsiLiteral) {
            return this.createReferenceSet((PsiLiteral)psiExpression, s).resolvePackage();
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<Collection<PsiPackage>> context) {
        PsiLiteral psiLiteral;
        if (context == null) {
            PackageJamConverter.$$$reportNull$$$0(1);
        }
        if ((psiLiteral = context.getPsiLiteral()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PackageJamConverter.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String value = context.getStringValue();
        if (value == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PackageJamConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = this.createReferenceSet(psiLiteral, value).getPsiReferences();
        if (psiReferenceArray == null) {
            PackageJamConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @NotNull
    private PackageReferenceSet createReferenceSet(@NotNull PsiLiteral psiLiteral, String value) {
        if (psiLiteral == null) {
            PackageJamConverter.$$$reportNull$$$0(5);
        }
        return new SpringAntPatternPackageReferenceSet(value, (PsiElement)psiLiteral, ElementManipulators.getOffsetInElement((PsiElement)psiLiteral), SpringReferenceUtils.getResolveScope((PsiElement)psiLiteral));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/converters/PackageJamConverter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/converters/PackageJamConverter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculatePackagesOnFakeElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

