/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.highlighting.xml.InjectionValueTypeInspection;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.util.UtilList;
import com.intellij.spring.model.xml.util.UtilMap;
import com.intellij.spring.model.xml.util.UtilSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UtilSchemaInspection
extends InjectionValueTypeInspection {
    @Override
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        if (!SpringDomUtils.hasNamespace(domFileElement, "Spring Util namespace key")) {
            return;
        }
        Beans beans = (Beans)domFileElement.getRootElement();
        for (UtilSet springSet : DomUtil.getDefinedChildrenOfType((DomElement)beans, UtilSet.class, (boolean)true, (boolean)false)) {
            UtilSchemaInspection.checkSetBean(springSet, holder);
            this.checkElementsHolder(springSet, holder);
        }
        for (UtilList list : DomUtil.getDefinedChildrenOfType((DomElement)beans, UtilList.class, (boolean)true, (boolean)false)) {
            UtilSchemaInspection.checkListBean(list, holder);
            this.checkElementsHolder(list, holder);
        }
        for (UtilMap map : DomUtil.getDefinedChildrenOfType((DomElement)beans, UtilMap.class, (boolean)true, (boolean)false)) {
            UtilSchemaInspection.checkMapBean(map, holder);
        }
    }

    private void checkElementsHolder(ListOrSet springSet, DomElementAnnotationHolder holder) {
        this.checkSpringPropertyCollection(springSet, holder);
    }

    private static void checkMapBean(UtilMap map, DomElementAnnotationHolder holder) {
        UtilSchemaInspection.checkProperClass(map.getMapClass(), Map.class, holder);
    }

    private static void checkListBean(UtilList list, DomElementAnnotationHolder holder) {
        UtilSchemaInspection.checkProperClass(list.getListClass(), List.class, holder);
    }

    private static void checkSetBean(UtilSet set, DomElementAnnotationHolder holder) {
        UtilSchemaInspection.checkProperClass(set.getSetClass(), Set.class, holder);
    }

    private static void checkProperClass(GenericAttributeValue<PsiClass> attrClass, Class<?> aClass, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(attrClass)) {
            return;
        }
        PsiClass psiClass = (PsiClass)attrClass.getValue();
        if (psiClass != null && !UtilSchemaInspection.isAssignable(psiClass, aClass)) {
            holder.createProblem(attrClass, SpringBundle.message("util.required.class.message", aClass.getName()), new LocalQuickFix[0]);
        }
    }

    private static boolean isAssignable(PsiClass psiClass, Class<?> fromClass) {
        Project project = psiClass.getProject();
        PsiType fromType = PsiTypeUtil.getInstance(project).findType(fromClass);
        PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)psiClass);
        return fromType != null && fromType.isAssignableFrom((PsiType)classType);
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return "UtilSchemaInspection";
    }
}

