/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.custom.ParseCustomBeanIntention;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnparsedCustomBeanInspection
extends SpringBeanInspectionBase {
    @NotNull
    public String getShortName() {
        return "UnparsedCustomBeanInspection";
    }

    @Override
    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            UnparsedCustomBeanInspection.$$$reportNull$$$0(0);
        }
        return new SpringModelVisitor(){

            @Override
            protected boolean visitBean(CommonSpringBean bean) {
                if (bean instanceof CustomBeanWrapper) {
                    CustomBeanWrapper wrapper = (CustomBeanWrapper)bean;
                    if (wrapper.isParsed()) {
                        return true;
                    }
                    if (ParseCustomBeanIntention.isUnregisteredNamespace(wrapper)) {
                        holder.createProblem((DomElement)wrapper, SpringBundle.message("unparsed.custom.bean.message", new Object[0]), new LocalQuickFix[0]);
                    } else {
                        AnAction reportProblemAction = ActionManager.getInstance().getAction("ReportProblem");
                        String reportProblemActionText = reportProblemAction.getTemplatePresentation().getText();
                        holder.createProblem((DomElement)wrapper, SpringBundle.message("UnparsedCustomBeanInspection.unsupported.tag", wrapper.getXmlElementName(), wrapper.getXmlElementNamespace(), reportProblemActionText), new LocalQuickFix[0]);
                    }
                }
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/highlighting/xml/UnparsedCustomBeanInspection", "createVisitor"));
    }
}

