/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.PsiClassConverter;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ExtendsClassChecker;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringXmlModelInspection
extends BasicDomElementsInspection<Beans> {
    public SpringXmlModelInspection() {
        super(Beans.class, new Class[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SpringXmlModelInspection";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        Converter converter;
        int oldSize = holder.getSize();
        super.checkDomElement(element, holder, helper);
        if (oldSize != holder.getSize() || !(element instanceof GenericDomValue)) {
            return;
        }
        if (element.getAnnotation(Convert.class) != null && ((converter = ((GenericDomValue)element).getConverter()) instanceof PsiClassConverter || converter instanceof CanonicalPsiTypeConverter)) {
            return;
        }
        ExtendsClassChecker.checkExtendsClassInReferences((GenericDomValue)((GenericDomValue)element), (DomElementAnnotationHolder)holder);
    }

    private static boolean hasInjections(GenericDomValue value) {
        if (StringUtil.isEmptyOrSpaces((String)value.getRawText())) {
            return false;
        }
        XmlElement element = value.getXmlElement();
        if (element instanceof XmlAttribute) {
            element = ((XmlAttribute)element).getValueElement();
        }
        return element != null && InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles((PsiElement)element) != null;
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value) {
        return !SpringBeanScope.class.equals((Object)DomUtil.getGenericValueParameter((Type)value.getDomElementType())) && super.shouldCheckResolveProblems(value) && SpringXmlModelInspection.isInActiveProfile((DomElement)value) && !PlaceholderUtils.getInstance().isPlaceholder(value) && !SpringXmlModelInspection.hasInjections(value);
    }

    private static boolean isInActiveProfile(@NotNull DomElement value) {
        Beans beans;
        if (value == null) {
            SpringXmlModelInspection.$$$reportNull$$$0(0);
        }
        if ((beans = (Beans)DomUtil.getParentOfType((DomElement)value, Beans.class, (boolean)true)) != null) {
            CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)value.getXmlElement());
            return SpringProfileUtils.isActiveProfile(beans, model.getActiveProfiles());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/highlighting/xml/SpringXmlModelInspection", "isInActiveProfile"));
    }
}

