/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInactiveProfileHighlightingInspection
extends DomElementsInspection<Beans> {
    public SpringInactiveProfileHighlightingInspection() {
        super(Beans.class, new Class[0]);
    }

    protected ProblemDescriptor @Nullable [] checkDomFile(@NotNull DomFileElement<Beans> domFileElement, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (domFileElement == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(1);
        }
        SmartList descriptors = new SmartList();
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel springModel = SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (springModel != null) {
            Set<String> activeProfiles = springModel.getActiveProfiles();
            if (SpringProfileUtils.isActiveProfile(beans, activeProfiles)) {
                for (Beans innerBeans : beans.getBeansProfiles()) {
                    if (SpringProfileUtils.isActiveProfile(innerBeans, activeProfiles)) continue;
                    descriptors.add(this.createProblem(manager, innerBeans, springModel));
                }
            } else {
                descriptors.add(this.createProblem(manager, beans, springModel));
            }
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull Beans beans, @NotNull SpringModel springModel) {
        if (manager == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(2);
        }
        if (beans == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(3);
        }
        if (springModel == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(4);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)beans.getXmlTag(), SpringBundle.message("SpringInactiveProfilesHighlightingPass.inactive.profile", new Object[0]), true, this.getFixes(beans.getProfile().getExpressions(), springModel.getFileSet()), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        if (problemDescriptor == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(5);
        }
        return problemDescriptor;
    }

    public LocalQuickFix[] getFixes(@NotNull Set<String> names, @Nullable SpringFileSet set) {
        if (names == null) {
            SpringInactiveProfileHighlightingInspection.$$$reportNull$$$0(6);
        }
        if (set == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<Object> fixes = new ArrayList<Object>(names.size());
        for (String name : names) {
            if (name.startsWith("!")) {
                fixes.add(new DeactivateProfileQuickFix(name.substring(1), set));
                continue;
            }
            fixes.add(new ActivateProfileQuickFix(name, set));
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SpringInactiveProfileHighlightingInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDomFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeactivateProfileQuickFix
    implements LocalQuickFix {
        private final String myProfileName;
        private final SpringFileSet myFileSet;

        private DeactivateProfileQuickFix(String name, SpringFileSet set) {
            this.myProfileName = name;
            this.myFileSet = set;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.deactivate.profile", this.myProfileName);
            if (string == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.deactivate.profile.family.name", new Object[0]);
            if (string == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                DeactivateProfileQuickFix.$$$reportNull$$$0(3);
            }
            HashSet<String> activeProfiles = new HashSet<String>(this.myFileSet.getActiveProfiles());
            activeProfiles.remove(this.myProfileName);
            this.myFileSet.setActiveProfiles(activeProfiles);
            SpringProfileUtils.notifyProfilesChanged(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$DeactivateProfileQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$DeactivateProfileQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ActivateProfileQuickFix
    implements LocalQuickFix {
        private final String myProfileName;
        private final SpringFileSet myFileSet;

        private ActivateProfileQuickFix(String name, SpringFileSet set) {
            this.myProfileName = name;
            this.myFileSet = set;
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile", this.myProfileName);
            if (string == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("ActivateSpringProfileIntentionAction.activate.profile.family.name", new Object[0]);
            if (string == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ActivateProfileQuickFix.$$$reportNull$$$0(3);
            }
            HashSet<String> activeProfiles = new HashSet<String>(this.myFileSet.getActiveProfiles());
            activeProfiles.add(this.myProfileName);
            this.myFileSet.setActiveProfiles(activeProfiles);
            SpringProfileUtils.notifyProfilesChanged(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$ActivateProfileQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringInactiveProfileHighlightingInspection$ActivateProfileQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

