/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.DefaultDependencyCheck;
import com.intellij.spring.model.xml.beans.DependencyCheck;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDependencyCheckInspection
extends SpringBeanInspectionBase {
    private static final Set<String> myWrapperClasses = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"});

    @NotNull
    @NonNls
    public String getShortName() {
        return "SpringBeanDepedencyCheckInspection";
    }

    private static boolean isObjectsDependencyCheck(DependencyCheck dependencyCheckMode) {
        return dependencyCheckMode.equals((Object)DependencyCheck.OBJECTS) || dependencyCheckMode.equals((Object)DependencyCheck.ALL);
    }

    private static boolean isSimpleDependencyCheck(DependencyCheck dependencyCheckMode) {
        return dependencyCheckMode.equals((Object)DependencyCheck.SIMPLE) || dependencyCheckMode.equals((Object)DependencyCheck.ALL);
    }

    private static void checkSimpleAndObjectsDependencies(@NotNull SpringBean springBean, @NotNull SpringModel springModel, @NotNull DomElementAnnotationHolder holder, DependencyCheck dependencyCheck) {
        PsiClass beanClass;
        if (springBean == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(0);
        }
        if (springModel == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(2);
        }
        if ((beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) == null) {
            return;
        }
        ArrayList<PsiMethod> setters = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : beanClass.getAllMethods()) {
            if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod) || !psiMethod.hasModifierProperty("public")) continue;
            setters.add(psiMethod);
        }
        ArrayList<String> nonInjectedProperties = new ArrayList<String>();
        for (PsiMethod psiMethod : setters) {
            boolean accepted = SpringDependencyCheckInspection.acceptPropertyForCheck(psiMethod, dependencyCheck);
            if (!accepted || SpringDependencyCheckInspection.isPropertyInjected(springBean, psiMethod) || SpringDependencyCheckInspection.isObjectsDependencyCheck(dependencyCheck) && SpringAutowireUtil.isAutowired(springBean, springModel, psiMethod)) continue;
            nonInjectedProperties.add(PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod));
        }
        if (nonInjectedProperties.size() > 0) {
            String message = SpringBundle.message("bean.dependency.check.message", StringUtil.join(nonInjectedProperties, (String)","));
            holder.createProblem((DomElement)springBean, message, new LocalQuickFix[0]);
        }
    }

    private static boolean acceptPropertyForCheck(PsiMethod psiMethod, DependencyCheck dependencyCheck) {
        PsiType psiType = psiMethod.getParameterList().getParameters()[0].getType();
        boolean simpleProperty = SpringDependencyCheckInspection.isSimpleProperty(psiType);
        return simpleProperty && SpringDependencyCheckInspection.isSimpleDependencyCheck(dependencyCheck) || !simpleProperty && SpringDependencyCheckInspection.isObjectsDependencyCheck(dependencyCheck);
    }

    private static boolean isPropertyInjected(SpringBean springBean, PsiMethod psiMethod) {
        String beanClassPropertyName = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod);
        for (SpringPropertyDefinition springProperty : springBean.getAllProperties()) {
            if (!beanClassPropertyName.equals(springProperty.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        if (springBean == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(3);
        }
        if (beans == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            SpringDependencyCheckInspection.$$$reportNull$$$0(5);
        }
        if (PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) != null && model instanceof XmlSpringModel) {
            DependencyCheck dependencyCheck;
            DependencyCheck dependencyCheck2 = dependencyCheck = DomUtil.hasXml(springBean.getDependencyCheck()) ? (DependencyCheck)((Object)springBean.getDependencyCheck().getValue()) : null;
            if (dependencyCheck == null) {
                dependencyCheck = SpringDependencyCheckInspection.getDefaultDependencyCheck(((XmlSpringModel)model).getLocalModelsRoots());
            }
            if (dependencyCheck != null && !dependencyCheck.equals((Object)DependencyCheck.NONE) && !dependencyCheck.equals((Object)DependencyCheck.DEFAULT)) {
                SpringDependencyCheckInspection.checkSimpleAndObjectsDependencies(springBean, (SpringModel)model, holder, dependencyCheck);
            }
        }
    }

    @Nullable
    private static DependencyCheck getDefaultDependencyCheck(Set<DomFileElement<Beans>> roots) {
        for (DomFileElement<Beans> element : roots) {
            DependencyCheck value = DependencyCheck.fromDefault((DefaultDependencyCheck)((Object)((Beans)element.getRootElement()).getDefaultDependencyCheck().getValue()));
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static boolean isSimpleProperty(PsiType psiType) {
        boolean isArrayType = psiType instanceof PsiArrayType;
        return isArrayType ? SpringDependencyCheckInspection.isSimpleSpringType(((PsiArrayType)psiType).getComponentType()) : SpringDependencyCheckInspection.isSimpleSpringType(psiType);
    }

    private static boolean isSimpleSpringType(PsiType psiType) {
        if (psiType instanceof PsiPrimitiveType) {
            return true;
        }
        String typeName = psiType.getCanonicalText();
        if (myWrapperClasses.contains(typeName)) {
            return true;
        }
        if (String.class.getName().equals(typeName)) {
            return true;
        }
        return Class.class.getName().equals(typeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringDependencyCheckInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSimpleAndObjectsDependencies";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

