/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanAttributesInspection
extends SpringBeanInspectionBase {
    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            SpringBeanAttributesInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringBeanAttributesInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringBeanAttributesInspection.$$$reportNull$$$0(2);
        }
        SpringDomInspectionUtils utils = new SpringDomInspectionUtils(holder);
        if (!utils.onlyOneOf(springBean, springBean.getClazz(), springBean.getFactoryBean())) {
            utils.ifExistsOtherRequired(springBean, springBean.getFactoryBean(), springBean.getFactoryMethod());
        }
        utils.attributeWithDefaultSuperfluous(springBean.getAbstract(), Boolean.FALSE);
        utils.attributeWithDefaultSuperfluous(springBean.getSingleton(), Boolean.TRUE);
        utils.attributeWithDefaultSuperfluous(springBean.getScope(), SpringBeanScope.SINGLETON_SCOPE);
        if (springBean.getParent() instanceof SpringValueHolder) {
            utils.attributeSuperfluous(springBean.getId());
            utils.attributeSuperfluous(springBean.getName());
            utils.attributeSuperfluous(springBean.getScope());
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SpringBeanAttributesInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "springBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "beans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/SpringBeanAttributesInspection";
        objectArray[2] = "checkBean";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

