/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.factories.SpringFactoryBeansManagerImpl;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryMethodInspection
extends SpringBeanInspectionBase {
    @NonNls
    @NotNull
    public String getShortName() {
        return "SpringFactoryMethodInspection";
    }

    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        GenericAttributeValue<PsiMethod> factoryMethodAttribute;
        if (springBean == null) {
            FactoryMethodInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            FactoryMethodInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            FactoryMethodInspection.$$$reportNull$$$0(2);
        }
        if (!DomUtil.hasXml(factoryMethodAttribute = springBean.getFactoryMethod())) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)factoryMethodAttribute.getValue();
        if (factoryMethod != null) {
            boolean isStatic = factoryMethod.hasModifierProperty("static");
            SpringBeanPointer factoryBean = (SpringBeanPointer)springBean.getFactoryBean().getValue();
            if (!isStatic && factoryBean == null) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.must.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            } else if (isStatic && factoryBean != null) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.must.not.be.static", factoryMethod.getName()), new LocalQuickFix[0]);
            }
            if (!SpringFactoryBeansManagerImpl.hasFactoryReturnType(factoryMethod)) {
                holder.createProblem(factoryMethodAttribute, SpringBundle.message("method.cannot.instantiate.bean", factoryMethod.getName()), new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "springBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "beans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/FactoryMethodInspection";
        objectArray[2] = "checkBean";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

