/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.context.Filter;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.model.xml.context.Type;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ContextComponentScanInconsistencyInspection
extends SpringBeanInspectionBase {
    @Override
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        List packagesScanBeans = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), SpringBeansPackagesScanBean.class, (boolean)true, (boolean)false);
        for (SpringBeansPackagesScanBean componentScan : packagesScanBeans) {
            ContextComponentScanInconsistencyInspection.checkComponentScan(componentScan, holder);
        }
    }

    private static void checkComponentScan(@NotNull SpringBeansPackagesScanBean componentScan, @NotNull DomElementAnnotationHolder holder) {
        if (componentScan == null) {
            ContextComponentScanInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ContextComponentScanInconsistencyInspection.$$$reportNull$$$0(1);
        }
        for (Filter filter : componentScan.getExcludeFilters()) {
            ContextComponentScanInconsistencyInspection.checkFilterType(filter, holder);
        }
        for (Filter filter : componentScan.getIncludeFilters()) {
            ContextComponentScanInconsistencyInspection.checkFilterType(filter, holder);
        }
    }

    private static void checkFilterType(@NotNull Filter filter, @NotNull DomElementAnnotationHolder holder) {
        Object value;
        Type type;
        if (filter == null) {
            ContextComponentScanInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ContextComponentScanInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if ((type = (Type)((Object)filter.getType().getValue())) != null && type == Type.ANNOTATION && (value = filter.getExpression().getValue()) instanceof PsiClass && !((PsiClass)value).isAnnotationType()) {
            holder.createProblem(filter.getExpression(), SpringBundle.message("ContextComponentScanInconsistencyInspection.annotation.is.expected.here", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "ContextComponentScanInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentScan";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/xml/ContextComponentScanInconsistencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkComponentScan";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFilterType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

