/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringJavaConfigInspectionBase;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringJavaConfigExternalBeansErrorInspection
extends SpringJavaConfigInspectionBase {
    @Override
    protected void checkJavaConfiguration(SpringJavaConfiguration javaConfiguration, Module module, ProblemsHolder holder) {
        if (javaConfiguration instanceof JavaConfigConfiguration) {
            SpringJavaConfigExternalBeansErrorInspection.checkExternalBean((JavaConfigConfiguration)javaConfiguration, holder);
        }
    }

    private static void checkExternalBean(JavaConfigConfiguration configuration, ProblemsHolder holder) {
        List<? extends SpringJavaExternalBean> list = configuration.getExternalBeans();
        if (list.size() > 0) {
            for (SpringJavaExternalBean springJavaExternalBean : list) {
                SpringJavaConfigExternalBeansErrorInspection.checkExternalBeanExist(springJavaExternalBean, holder);
                SpringJavaConfigExternalBeansErrorInspection.checkExternalBeanType(springJavaExternalBean, holder);
            }
        }
    }

    private static void checkExternalBeanType(SpringJavaExternalBean externalBean, ProblemsHolder holder) {
        List<SpringBeanPointer> beans = SpringOldJavaConfigurationUtil.findExternalBeans(externalBean.getPsiElement());
        if (beans.size() == 1) {
            SpringBeanPointer springBean = beans.get(0);
            PsiMethod psiMethod = externalBean.getPsiElement();
            PsiType returnType = psiMethod.getReturnType();
            if (returnType instanceof PsiClassType) {
                PsiClassType beanClassType;
                PsiClassType externalBeanClassType;
                PsiClass beanClass = springBean.getBeanClass();
                if (beanClass != null && !(externalBeanClassType = (PsiClassType)returnType).isAssignableFrom((PsiType)(beanClassType = PsiTypesUtil.getClassType((PsiClass)beanClass)))) {
                    holder.registerProblem((PsiElement)psiMethod.getReturnTypeElement(), SpringBundle.message("spring.java.configuration.inspection.incorrect.return.type.of.external.bean", beanClassType.getClassName()), new LocalQuickFix[0]);
                }
            } else {
                holder.registerProblem((PsiElement)psiMethod.getReturnTypeElement(), SpringBundle.message("spring.java.configuration.inspection.class.type.expected", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkExternalBeanExist(SpringJavaExternalBean externalBean, ProblemsHolder holder) {
        PsiMethod member = externalBean.getPsiElement();
        if (SpringOldJavaConfigurationUtil.findExternalBeans(externalBean.getPsiElement()).size() == 0) {
            PsiIdentifier psiIdentifier = member.getNameIdentifier();
            holder.registerProblem((PsiElement)psiIdentifier, SpringBundle.message("spring.java.configuration.inspection.cannot.find.external.bean", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SpringJavaConfigExternalBeansErrorInspection";
    }
}

