/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.highlighting.jam.SpringConfigurationProxyMethodsInspectionKt;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/model/highlighting/jam/SpringConfigurationProxyMethodsInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "aClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "configurationAnnotation", "Lcom/intellij/spring/model/jam/stereotype/SpringConfiguration;", "sourcePsiClass", "Lcom/intellij/psi/PsiClass;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isSpringComponentOrBeanSource", "intellij.spring.core"})
public final class SpringConfigurationProxyMethodsInspection
extends SpringUastInspectionBase {
    @NotNull
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)aClass.getJavaPsi()));
        if (module == null || !SpringCommonUtils.isSpringEnabledModule(module)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass sourcePsiClass = aClass.getJavaPsi();
        if (!SpringCommonUtils.isSpringBeanCandidateClass(sourcePsiClass)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringConfiguration configurationAnnotation = (SpringConfiguration)SpringConfiguration.META.getJamElement((PsiModifierListOwner)sourcePsiClass);
        if (configurationAnnotation != null && configurationAnnotation.isProxyBeanMethods()) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!this.isSpringComponentOrBeanSource(sourcePsiClass)) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsiClass.getContainingFile(), isOnTheFly);
        Set beanProviderMethodNames = SpringConfigurationProxyMethodsInspectionKt.access$getAllBeanProviderMethodNames(module);
        if (beanProviderMethodNames.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        for (UMethod uMethod : aClass.getMethods()) {
            PsiElement methodBody;
            UExpression uExpression = uMethod.getUastBody();
            PsiElement psiElement = methodBody = uExpression != null ? uExpression.getSourcePsi() : null;
            if (psiElement == null) continue;
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, beanProviderMethodNames, configurationAnnotation, sourcePsiClass, holder){
                final /* synthetic */ SpringConfigurationProxyMethodsInspection this$0;
                final /* synthetic */ Set $beanProviderMethodNames;
                final /* synthetic */ SpringConfiguration $configurationAnnotation;
                final /* synthetic */ PsiClass $sourcePsiClass;
                final /* synthetic */ ProblemsHolder $holder;

                public void visitElement(@NotNull PsiElement element) {
                    UCallExpression node;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    UCallExpression uCallExpression = node = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                    if (Intrinsics.areEqual((Object)(uCallExpression != null ? uCallExpression.getKind() : null), (Object)UastCallKind.METHOD_CALL) && CollectionsKt.contains((Iterable)this.$beanProviderMethodNames, (Object)node.getMethodName())) {
                        SpringConfigurationProxyMethodsInspection.access$checkMethodCall(this.this$0, node, this.$configurationAnnotation, this.$sourcePsiClass, this.$holder);
                    }
                    super.visitElement(element);
                }
                {
                    this.this$0 = this$0;
                    this.$beanProviderMethodNames = $captured_local_variable$1;
                    this.$configurationAnnotation = $captured_local_variable$2;
                    this.$sourcePsiClass = $captured_local_variable$3;
                    this.$holder = $captured_local_variable$4;
                }
            });
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"holder.resultsArray");
        return problemDescriptorArray;
    }

    private final boolean isSpringComponentOrBeanSource(PsiClass sourcePsiClass) {
        if (SpringCommonUtils.isConfigurationOrMeta(sourcePsiClass)) {
            return true;
        }
        if (SpringCommonUtils.isComponentOrMeta(sourcePsiClass)) {
            return true;
        }
        SpringManager springManager = SpringManager.getInstance(sourcePsiClass.getProject());
        SpringModel model = springManager.getSpringModelByFile(sourcePsiClass.getContainingFile());
        if (model == null) {
            return false;
        }
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)model, sourcePsiClass);
    }

    private final void checkMethodCall(UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        UIdentifier uIdentifier = node.getMethodIdentifier();
        if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
            return;
        }
        UIdentifier methodName = uIdentifier;
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod callExprMethod = psiMethod;
        PsiClass psiClass = callExprMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"callExprMethod.containingClass ?: return");
        PsiClass callTargetClass = psiClass;
        if (ContextJavaBean.METHOD_META.getJamElement((PsiModifierListOwner)callExprMethod) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sourcePsiClass, (PsiClass)callTargetClass, (boolean)true)) {
            return;
        }
        String message = configurationAnnotation != null ? SpringBundle.message("bean.method.called.from.configuration.without.proxy", new Object[0]) : SpringBundle.message("bean.method.called.without.proxy", new Object[0]);
        holder.registerProblem((PsiElement)methodName, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    public SpringConfigurationProxyMethodsInspection() {
        super(Reflection.getOrCreateKotlinClass(UClass.class));
    }

    public static final /* synthetic */ void access$checkMethodCall(SpringConfigurationProxyMethodsInspection $this, UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        $this.checkMethodCall(node, configurationAnnotation, sourcePsiClass, holder);
    }
}

