/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

public abstract class SpringBeanPointerResolveInspection
extends AbstractBaseJavaLocalInspectionTool {
    protected static boolean isPlainJavaFileInSpringModule(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringBeanPointerResolveInspection.$$$reportNull$$$0(0);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiElement.getContainingFile())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        return SpringCommonUtils.hasSpringFacet(module) || SpringModelUtils.getInstance().hasAutoConfiguredModels(module);
    }

    public static void checkBeanPointerResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer> element) {
        String beanType = null;
        JamConverter converter = element.getConverter();
        if (converter instanceof SpringBeanReferenceJamConverter) {
            beanType = ((SpringBeanReferenceJamConverter)converter).getBaseClass();
        }
        SpringBeanPointerResolveInspection.checkBeanPointerResolve(holder, element, beanType);
    }

    public static void checkBeanPointerResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer> element, @Nullable String beanType) {
        PsiAnnotationMemberValue memberValue;
        String beanName = element.getStringValue();
        if (beanName != null && (memberValue = element.getPsiElement()) != null) {
            PsiElement problemPsiElement;
            PsiClass psiClass;
            SpringBeanPointer value = (SpringBeanPointer)element.getValue();
            if (value == null) {
                PsiElement problemPsiElement2 = SpringBeanPointerResolveInspection.getProblemPsiElement((PsiElement)memberValue);
                if (problemPsiElement2 != null) {
                    holder.registerProblem(problemPsiElement2, SpringApiBundle.message("model.bean.error.message", beanName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            } else if (StringUtil.isNotEmpty((String)beanType) && (psiClass = value.getBeanClass()) != null && !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)beanType) && (problemPsiElement = SpringBeanPointerResolveInspection.getProblemPsiElement((PsiElement)memberValue)) != null) {
                holder.registerProblem(problemPsiElement, SpringApiBundle.message("bean.must.be.of.type", beanType), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static PsiElement getProblemPsiElement(PsiElement element) {
        UElement uElement = UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
        if (uElement == null) {
            return null;
        }
        return uElement.getSourcePsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/highlighting/jam/SpringBeanPointerResolveInspection", "isPlainJavaFileInSpringModule"));
    }
}

