/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.jam.SpringAutowiredMemberUsageInfo;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SpringAutowiredBeanFindUsagesHandler
extends FindUsagesHandler {
    public SpringAutowiredBeanFindUsagesHandler(PsiElement psiMember) {
        super(psiMember);
    }

    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<? super UsageInfo> processor2, @NotNull FindUsagesOptions options) {
        if (element == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(1);
        }
        if (options == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(2);
        }
        if (!super.processElementUsages(element, processor2, options)) {
            return false;
        }
        SpringBeanPointer pointer = (SpringBeanPointer)ReadAction.compute(() -> {
            CommonSpringBean bean = SpringBeanUtils.getInstance().findBean(this.getPsiElement());
            if (bean == null) {
                return null;
            }
            return BeanService.getInstance().createSpringBeanPointer(bean);
        });
        if (pointer == null) {
            return true;
        }
        return SpringAutowiredBeanFindUsagesHandler.processAutowiredBeans(element, processor2, options, pointer);
    }

    public static boolean processAutowiredBeans(PsiElement element, @NotNull Processor<? super UsageInfo> processor2, FindUsagesOptions options, SpringBeanPointer pointer) {
        if (processor2 == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return true;
            }
            MultiMap injectionPoints = new MultiMap();
            GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
            for (String anno : SpringAutowireUtil.getAutowiredAnnotations(module)) {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)element.getProject()).findClass(anno, scope);
                if (psiClass == null) continue;
                AnnotatedElementsSearch.searchPsiMembers((PsiClass)psiClass, (SearchScope)options.searchScope).forEach(member -> {
                    PsiClass containingClass = member.getContainingClass();
                    if (containingClass != null) {
                        injectionPoints.putValue((Object)containingClass, member);
                    }
                    return true;
                });
            }
            if (injectionPoints.size() > 0) {
                PsiType[] effectiveBeanTypes = pointer.getEffectiveBeanTypes();
                for (Map.Entry entry : injectionPoints.entrySet()) {
                    for (PsiMember psiMember : (Collection)entry.getValue()) {
                        PsiParameter[] parameters;
                        if (psiMember instanceof PsiField && SpringAutowiredBeanFindUsagesHandler.isAutowiredUsage((PsiVariable)((PsiField)psiMember), effectiveBeanTypes) && !processor2.process((Object)new SpringAutowiredMemberUsageInfo((PsiElement)psiMember))) {
                            return false;
                        }
                        if (!(psiMember instanceof PsiMethod)) continue;
                        for (PsiParameter parameter : parameters = ((PsiMethod)psiMember).getParameterList().getParameters()) {
                            if (!SpringAutowiredBeanFindUsagesHandler.isAutowiredUsage((PsiVariable)parameter, effectiveBeanTypes) || processor2.process((Object)new SpringAutowiredMemberUsageInfo((PsiElement)parameter))) continue;
                            return false;
                        }
                    }
                }
            }
            return true;
        });
    }

    private static boolean isAutowiredUsage(@NotNull PsiVariable variable, PsiType @NotNull [] effectiveBeanTypes) {
        if (variable == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(4);
        }
        if (effectiveBeanTypes == null) {
            SpringAutowiredBeanFindUsagesHandler.$$$reportNull$$$0(5);
        }
        PsiType variableType = SpringAutowireUtil.getAutowiredEffectiveBeanTypes(variable.getType());
        for (PsiType psiType : effectiveBeanTypes) {
            if (!variableType.isAssignableFrom(psiType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveBeanTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringAutowiredBeanFindUsagesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAutowiredBeans";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAutowiredUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

