/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.validation.SpringProgrammaticConfigurationCollector;
import com.intellij.spring.model.highlighting.config.SetupProgrammaticContextFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFacetProgrammaticInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringFacetProgrammaticInspection.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isInternal()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        if (!SpringLibraryUtil.hasSpringLibrary(project)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringProgrammaticConfigurationCollector collector = new SpringProgrammaticConfigurationCollector(project);
        collector.collect((ProgressIndicator)new EmptyProgressIndicator(), GlobalSearchScope.fileScope((PsiFile)file));
        List<PsiElement> results = collector.getResults();
        if (results.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        boolean hasSpringFacet = SpringCommonUtils.hasSpringFacet(module);
        SmartList problems = new SmartList();
        for (PsiElement element : results) {
            SetupProgrammaticContextFix fix2 = hasSpringFacet ? new SetupProgrammaticContextFix(element) : null;
            problems.add(manager.createProblemDescriptor(element, SpringBundle.message("spring.facet.programmatic.inspection.spring.context", new Object[0]), (LocalQuickFix)fix2, ProblemHighlightType.WEAK_WARNING, isOnTheFly));
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SpringFacetProgrammaticInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/config/SpringFacetProgrammaticInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

