/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.beanValidation;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModelImpl;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringValidationCustomComponentsDiscoverer
extends CustomLocalComponentsDiscoverer {
    @NonNls
    private static final String VALIDATOR_FACTORY = "javax.validation.ValidatorFactory";
    private static final String CONSTRAINT_VALIDATOR = "javax.validation.ConstraintValidator";

    @Override
    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel springModel) {
        Module module;
        if (springModel == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(0);
        }
        if ((module = springModel.getModule()) == null || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiClass constraintValidator = SpringCommonUtils.findLibraryClass(module, CONSTRAINT_VALIDATOR);
        if (constraintValidator == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiClass validatorFactory = SpringCommonUtils.findLibraryClass(module, VALIDATOR_FACTORY);
        if (validatorFactory == null || !this.doesBeanExist(springModel, validatorFactory)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(3);
            }
            return list;
        }
        HashSet<CommonSpringBean> myValidators = new HashSet<CommonSpringBean>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiClass aClass : ClassInheritorsSearch.search((PsiClass)constraintValidator, (SearchScope)scope, (boolean)true).findAll()) {
            PsiModifierList modifierList;
            if (aClass.isInterface() || (modifierList = aClass.getModifierList()) == null || modifierList.hasModifierProperty("abstract")) continue;
            myValidators.add(new CustomSpringComponent(aClass));
        }
        HashSet<CommonSpringBean> hashSet = myValidators;
        if (hashSet == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public boolean doesBeanExist(@NotNull LocalModel springModel, PsiClass validatorFactory) {
        if (springModel == null) {
            SpringValidationCustomComponentsDiscoverer.$$$reportNull$$$0(5);
        }
        CommonProcessors.FindFirstProcessor findFirstProcessor2 = new CommonProcessors.FindFirstProcessor();
        SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass(validatorFactory);
        RecursionManager.doPreventingRecursion((Object)springModel, (boolean)false, () -> {
            if (springModel instanceof LocalXmlModelImpl) {
                ((LocalXmlModelImpl)springModel).processLocalBeansByClass(params, (Processor<SpringBeanPointer>)findFirstProcessor2, true);
            } else if (springModel instanceof CacheableCommonSpringModel) {
                ((CacheableCommonSpringModel)((Object)springModel)).processLocalBeansByClass(params, (Processor<SpringBeanPointer>)findFirstProcessor2);
            }
            return null;
        });
        return findFirstProcessor2.isFound();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/extensions/beanValidation/SpringValidationCustomComponentsDiscoverer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doesBeanExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

