/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.events.jam;

import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.constants.SpringConstants;
import com.intellij.spring.model.events.beans.PublishEventPointDescriptor;
import com.intellij.spring.model.events.jam.CustomSpringEventListener;
import com.intellij.spring.model.events.jam.SpringBeanEventListener;
import com.intellij.spring.model.events.jam.SpringEventListener;
import com.intellij.spring.model.events.jam.SpringJamEventListener;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringEventModelUtils {
    private static final String PUBLISH_EVENT_METHOD = "publishEvent";

    @NotNull
    public static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module, @NotNull PsiType handledType) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(0);
        }
        if (handledType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(1);
        }
        List<PublishEventPointDescriptor> list = SpringEventModelUtils.filter(SpringEventModelUtils.getPublishPoints(module), handledType);
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> getPublishPoints(@NotNull Module module) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(3);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            LinkedHashSet<PublishEventPointDescriptor> descriptors = new LinkedHashSet<PublishEventPointDescriptor>();
            for (PsiMethod publishEventMethod : SpringEventModelUtils.getPublishEventMethods(module)) {
                descriptors.addAll(SpringEventModelUtils.searchPublishPoints(publishEventMethod, (SearchScope)scope));
            }
            descriptors.addAll(SpringEventModelUtils.searchEventListenerDescriptors(module));
            ArrayList cacheValue = descriptors.isEmpty() ? Collections.emptyList() : new ArrayList(descriptors);
            return CachedValueProvider.Result.createSingleDependency(cacheValue, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (collection == null) {
            SpringEventModelUtils.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static PsiMethod[] getPublishEventMethods(@NotNull Module module) {
        PsiClass eventPublisherClass;
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(5);
        }
        if ((eventPublisherClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.context.ApplicationEventPublisher")) != null) {
            return eventPublisherClass.findMethodsByName(PUBLISH_EVENT_METHOD, false);
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    private static List<PublishEventPointDescriptor> filter(@NotNull Collection<PublishEventPointDescriptor> allDescriptors, @NotNull PsiType eventType) {
        if (allDescriptors == null) {
            SpringEventModelUtils.$$$reportNull$$$0(6);
        }
        if (eventType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(7);
        }
        return ContainerUtil.filter(allDescriptors, descriptor -> {
            PsiType publishType = descriptor.getEventType();
            return publishType != null && eventType.isAssignableFrom(publishType);
        });
    }

    @NotNull
    public static List<SpringEventListener> getEventListeners(@NotNull Module module, @NotNull PsiType publishType) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(8);
        }
        if (publishType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.filter(SpringEventModelUtils.getEventListeners(module), listener2 -> {
            for (PsiType eventType : SpringEventModelUtils.getEventListenerHandledType(listener2)) {
                if (!eventType.isAssignableFrom(publishType)) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<SpringEventListener> getEventListeners(@NotNull Module module) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(11);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
        List list = (List)cachedValuesManager.getCachedValue((UserDataHolder)module, () -> {
            SmartList result = new SmartList();
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JamService service = JamService.getJamService((Project)module.getProject());
            result.addAll(service.getJamMethodElements(SpringJamEventListener.SEM_KEY, "org.springframework.context.event.EventListener", scope));
            JamAnnotationTypeUtil annotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
            List customAnnotations = ContainerUtil.mapNotNull(annotationTypeUtil.getAnnotationTypesWithChildren("org.springframework.context.event.EventListener"), PsiClass::getQualifiedName);
            for (String annotation : customAnnotations) {
                result.addAll(service.getJamMethodElements(CustomSpringEventListener.JAM_KEY, annotation, scope));
            }
            SpringEventModelUtils.collectEventListenerBeans(module, scope, (List<SpringEventListener>)result);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())});
        });
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static void collectEventListenerBeans(@NotNull Module module, @NotNull GlobalSearchScope scope, @NotNull List<SpringEventListener> result) {
        JavaPsiFacade javaPsiFacade;
        PsiClass listenerInterface;
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(14);
        }
        if (result == null) {
            SpringEventModelUtils.$$$reportNull$$$0(15);
        }
        if ((listenerInterface = (javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass("org.springframework.context.ApplicationListener", scope)) != null) {
            PsiClass applicationEventClass = javaPsiFacade.findClass("org.springframework.context.ApplicationEvent", scope);
            Query entries = ClassInheritorsSearch.search((PsiClass)listenerInterface, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            for (PsiClass entry : entries) {
                PsiMethod[] onEventMethods;
                if (!SpringCommonUtils.isSpringBeanCandidateClass(entry)) continue;
                for (PsiMethod method : onEventMethods = entry.findMethodsByName("onApplicationEvent", false)) {
                    SpringBeanEventListener beanEventListener;
                    if (!SpringEventModelUtils.isValidReceiverMethod(method, applicationEventClass) || (beanEventListener = (SpringBeanEventListener)SpringBeanEventListener.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
                    result.add(beanEventListener);
                }
            }
        }
    }

    private static boolean isValidReceiverMethod(PsiMethod method, PsiClass applicationEventClass) {
        PsiClass resolvedClass;
        String parameterClassName;
        if (!PsiType.VOID.equals((Object)method.getReturnType()) || method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = method.getParameterList().getParameters()[0];
        return !(parameter.getType() instanceof PsiClassType) || (parameterClassName = ((PsiClassType)parameter.getType()).getClassName()) != null && !parameterClassName.equals("ApplicationEvent") || (resolvedClass = ((PsiClassType)parameter.getType()).resolve()) != null && !resolvedClass.isEquivalentTo((PsiElement)applicationEventClass);
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> searchEventListenerDescriptors(@NotNull Module module) {
        if (module == null) {
            SpringEventModelUtils.$$$reportNull$$$0(16);
        }
        ArrayList<PublishEventPointDescriptor> descriptors = new ArrayList<PublishEventPointDescriptor>();
        for (SpringEventListener listener2 : SpringEventModelUtils.getEventListeners(module)) {
            PsiType returnType;
            PsiMethod psiMethod = listener2.getPsiElement();
            if (psiMethod == null || (returnType = psiMethod.getReturnType()) == null || PsiType.VOID.equals((Object)returnType)) continue;
            descriptors.add(PublishEventPointDescriptor.create(psiMethod, module));
        }
        ArrayList<PublishEventPointDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            SpringEventModelUtils.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PublishEventPointDescriptor> searchPublishPoints(@NotNull PsiMethod publishEventMethod, @NotNull SearchScope searchScope) {
        if (publishEventMethod == null) {
            SpringEventModelUtils.$$$reportNull$$$0(18);
        }
        if (searchScope == null) {
            SpringEventModelUtils.$$$reportNull$$$0(19);
        }
        ArrayList<PublishEventPointDescriptor> result = new ArrayList<PublishEventPointDescriptor>();
        MethodReferencesSearch.search((PsiMethod)publishEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            List arguments;
            UElement expression = UastContextKt.toUElement((PsiElement)psiReference.getElement());
            UCallExpression callExpression = UastUtils.getUCallExpression((UElement)expression);
            if (callExpression != null && (arguments = callExpression.getValueArguments()).size() == 1) {
                result.add(PublishEventPointDescriptor.create((UExpression)arguments.get(0)));
            }
            return true;
        });
        ArrayList<PublishEventPointDescriptor> arrayList = result;
        if (arrayList == null) {
            SpringEventModelUtils.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<PsiType> getEventListenerHandledType(@NotNull SpringEventListener eventListener) {
        PsiMethod psiMethod;
        if (eventListener == null) {
            SpringEventModelUtils.$$$reportNull$$$0(21);
        }
        if ((psiMethod = eventListener.getPsiElement()) == null) {
            List<PsiType> list = Collections.emptyList();
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(22);
            }
            return list;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (parameters.length == 1) {
            Set<PsiType> set = Collections.singleton(parameters[0].getType());
            if (set == null) {
                SpringEventModelUtils.$$$reportNull$$$0(23);
            }
            return set;
        }
        if (parameters.length == 0) {
            List list = ContainerUtil.mapNotNull(eventListener.getEventListenerClasses(), PsiTypesUtil::getClassType);
            if (list == null) {
                SpringEventModelUtils.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            SpringEventModelUtils.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static boolean isPublishEventExpression(@NotNull UCallExpression psiElement) {
        PsiMethod element;
        if (psiElement == null) {
            SpringEventModelUtils.$$$reportNull$$$0(26);
        }
        if (PUBLISH_EVENT_METHOD.equals(psiElement.getMethodName()) && (element = psiElement.resolve()) != null) {
            PsiClass containingClass = element.getContainingClass();
            return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.springframework.context.ApplicationEventPublisher");
        }
        return false;
    }

    @Nullable
    public static PsiType getEventType(@Nullable PsiType methodReturnType, @Nullable Module module) {
        PsiType[] parameters;
        if (methodReturnType == null) {
            return null;
        }
        if (methodReturnType instanceof PsiArrayType) {
            return ((PsiArrayType)methodReturnType).getComponentType();
        }
        if (methodReturnType instanceof PsiClassType && (parameters = ((PsiClassType)methodReturnType).getParameters()).length == 1 && SpringEventModelUtils.isEventWrapperType((PsiClassType)methodReturnType, module)) {
            return parameters[0];
        }
        return methodReturnType;
    }

    private static boolean isEventWrapperType(@NotNull PsiClassType returnType, @Nullable Module module) {
        PsiClass resolvedClass;
        if (returnType == null) {
            SpringEventModelUtils.$$$reportNull$$$0(27);
        }
        if ((resolvedClass = returnType.resolve()) == null) {
            return false;
        }
        String qualifiedName = resolvedClass.getQualifiedName();
        return SpringConstants.EVENT_WRAPPER_CLASSES.contains(qualifiedName) || SpringConstants.REACTIVE_EVENT_WRAPPER_CLASSES.contains(qualifiedName) && SpringLibraryUtil.isAtLeastVersion(module, SpringLibraryUtil.SpringVersion.V_5_2) && SpringEventModelUtils.hasReactorDependency(module);
    }

    private static boolean hasReactorDependency(Module module) {
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"reactor.core.publisher.Flux");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handledType";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishEventMethod";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventListener";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/events/jam/SpringEventModelUtils";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublishPoints";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListeners";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "searchEventListenerDescriptors";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "searchPublishPoints";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventListenerHandledType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPublishPoints";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPublishEventMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEventListeners";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectEventListenerBeans";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "searchEventListenerDescriptors";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "searchPublishPoints";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEventListenerHandledType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPublishEventExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isEventWrapperType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

