/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.SpringBeanNamesConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBeanNamesConverterImpl
extends SpringBeanNamesConverter {
    public String toString(List<String> strings, ConvertContext context) {
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize(s);
    }

    public PsiReference @NotNull [] createReferences(final GenericDomValue<List<String>> genericDomValue, final PsiElement element, final ConvertContext context) {
        List strings = (List)genericDomValue.getValue();
        if (strings != null) {
            ArrayList<1> references = new ArrayList<1>(strings.size());
            for (String string : strings) {
                int offset = element.getText().indexOf(string);
                if (offset < 0) continue;
                references.add(new PsiReferenceBase<PsiElement>(element, TextRange.from((int)offset, (int)string.length())){

                    public PsiElement resolve() {
                        DomElement bean = genericDomValue.getParent();
                        return bean instanceof CommonSpringBean ? BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean).getPsiElement() : null;
                    }

                    public boolean isSoft() {
                        return true;
                    }

                    public Object @NotNull [] getVariants() {
                        Object[] objectArray = SpringBeanCoreUtils.suggestBeanNames(SpringConverterUtil.getCurrentBean(context));
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return objectArray;
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        if (newElementName == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        SpringBean bean = (SpringBean)genericDomValue.getParent();
                        assert (bean != null);
                        bean.setName(newElementName);
                        return element;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElementName";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getVariants";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "handleElementRename";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
            PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                SpringBeanNamesConverterImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBeanNamesConverterImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl", "createReferences"));
    }
}

