/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanListConverter
extends DelimitedListConverter<SpringBeanPointer> {
    public SpringBeanListConverter() {
        super(",; ");
    }

    public boolean canResolveTo(Class<? extends PsiElement> elementClass) {
        return ReflectionUtil.isAssignable(SpringBeanPointer.class, elementClass);
    }

    @Nullable
    protected SpringBeanPointer convertString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        SpringModel model = SpringConverterUtil.getSpringModel(context);
        if (model == null) {
            return null;
        }
        return SpringModelSearchers.findBean(model, s);
    }

    @Nullable
    protected String toString(@Nullable SpringBeanPointer springBeanPointer) {
        return springBeanPointer == null ? null : springBeanPointer.getName();
    }

    @Nullable
    protected PsiElement resolveReference(SpringBeanPointer springBeanPointer, ConvertContext context) {
        return springBeanPointer == null ? null : springBeanPointer.getPsiElement();
    }

    protected String getUnresolvedMessage(String value) {
        return SpringApiBundle.message("model.bean.error.message", value);
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<? extends List<SpringBeanPointer>> genericDomValue) {
        SpringModel model = SpringConverterUtil.getSpringModel(context);
        if (model == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<SpringBeanPointer> variants = new ArrayList<SpringBeanPointer>();
        DomSpringBean currentBean = SpringConverterUtil.getCurrentBean(context);
        Collection<SpringBeanPointer> allBeans = this.getVariantBeans(context, model);
        for (SpringBeanPointer pointer : allBeans) {
            if (pointer.isReferenceTo(currentBean)) continue;
            for (String string : SpringModelVisitorUtils.getAllBeanNames(model, pointer)) {
                if (!StringUtil.isNotEmpty((String)string)) continue;
                variants.add(pointer.derive(string));
            }
        }
        List existingBeans = (List)genericDomValue.getValue();
        if (existingBeans != null) {
            Iterator it = variants.iterator();
            block2: while (it.hasNext()) {
                Object variant = ((SpringBeanPointer)it.next()).getSpringBean();
                for (SpringBeanPointer existing : existingBeans) {
                    if (!existing.isReferenceTo((CommonSpringBean)variant)) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        ArrayList result = new ArrayList(variants.size());
        for (SpringBeanPointer springBeanPointer : variants) {
            ContainerUtil.addIfNotNull(result, (Object)SpringConverterUtil.createCompletionVariant(springBeanPointer));
        }
        return result.toArray();
    }

    protected Collection<SpringBeanPointer> getVariantBeans(ConvertContext convertContext, @NotNull CommonSpringModel model) {
        List<PsiClassType> requiredBeanTypeClasses;
        if (model == null) {
            SpringBeanListConverter.$$$reportNull$$$0(0);
        }
        if (!(requiredBeanTypeClasses = SpringConverterUtil.getRequiredBeanTypeClasses(convertContext)).isEmpty()) {
            CommonSpringBean currentBean = SpringConverterUtil.getCurrentBeanCustomAware(convertContext);
            return SpringConverterUtil.getSmartVariants(currentBean, requiredBeanTypeClasses, model);
        }
        return model.getAllCommonBeans();
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<SpringBeanPointer>> genericDomValue, boolean delimitersOnly) {
        return new MyFixableReference(element, this.getTextRange(genericDomValue, start, end), context, genericDomValue, delimitersOnly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/model/converters/SpringBeanListConverter", "getVariantBeans"));
    }

    private final class MyFixableReference
    extends DelimitedListConverter.MyPsiReference
    implements LocalQuickFixProvider {
        private final Beans beans;

        private MyFixableReference(PsiElement element, TextRange range, ConvertContext context, GenericDomValue<List<SpringBeanPointer>> genericDomValue, boolean delimitersOnly) {
            super((DelimitedListConverter)SpringBeanListConverter.this, element, range, context, genericDomValue, delimitersOnly);
            this.beans = (Beans)genericDomValue.getParentOfType(Beans.class, false);
        }

        public LocalQuickFix[] getQuickFixes() {
            return SpringBeanResolveQuickFixManager.getInstance().getQuickFixes(this.myContext, this.beans, this.getValue(), SpringConverterUtil.getRequiredBeanTypeClasses(this.myContext));
        }
    }
}

