/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanFactoryMethodConverterImpl
extends SpringBeanFactoryMethodConverter {
    private static final String ASPECT_OF_METHOD_NAME = "aspectOf";

    @Override
    public PsiMethod fromString(@Nullable String methodName, ConvertContext context) {
        if (ASPECT_OF_METHOD_NAME.equals(methodName)) {
            return SpringBeanFactoryMethodConverterImpl.createAspectOfLightMethod(context.getPsiManager());
        }
        return super.fromString(methodName, context);
    }

    @Override
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        return SpringBeanFactoryMethodConverterImpl.getFactoryClass(springBean);
    }

    @Override
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(ConvertContext context, final boolean forCompletion) {
        final SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        final boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
        return new PsiMethodConverter.MethodAccepter(){

            @Override
            public boolean accept(PsiMethod psiMethod) {
                if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
                    return false;
                }
                PsiClass psiClass = psiMethod.getContainingClass();
                assert (psiClass != null);
                String containingClass = psiClass.getQualifiedName();
                return !(forCompletion && containingClass != null && containingClass.equals("java.lang.Object") || !SpringFactoryBeansManager.getInstance().isValidFactoryMethod(psiMethod, fromFactoryBean) || !forCompletion && !SpringBeanFactoryMethodConverterImpl.parametersResolved(springBean, psiMethod));
            }
        };
    }

    private static boolean parametersResolved(@NotNull SpringBean bean, @NotNull PsiMethod method) {
        if (bean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(0);
        }
        if (method == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(1);
        }
        if (SpringAutowireUtil.isConstructorAutowire(bean)) {
            return true;
        }
        XmlElement beanXmlElement = bean.getXmlElement();
        if (beanXmlElement == null) {
            return false;
        }
        List resolvedMethods = (List)RecursionManager.doPreventingRecursion((Object)beanXmlElement, (boolean)true, () -> SpringConstructorArgResolveUtil.findMatchingMethods(bean));
        return resolvedMethods != null && resolvedMethods.contains(method);
    }

    @NotNull
    public static List<PsiMethod> getFactoryMethodCandidates(@NotNull SpringBean springBean, @NotNull String methodName) {
        if (springBean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(3);
        }
        PsiClass factoryClass = SpringBeanFactoryMethodConverterImpl.getFactoryClass(springBean);
        SmartList result = new SmartList();
        if (factoryClass != null) {
            PsiMethod[] methods;
            if (ASPECT_OF_METHOD_NAME.equals(methodName)) {
                result.add(SpringBeanFactoryMethodConverterImpl.createAspectOfLightMethod(springBean.getPsiManager()));
            }
            if ((methods = MethodResolveProcessor.findMethod((PsiClass)factoryClass, (String)methodName)).length > 0) {
                boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
                for (PsiMethod method : methods) {
                    if (!SpringFactoryBeansManager.getInstance().isValidFactoryMethod(method, fromFactoryBean)) continue;
                    result.add(method);
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static LightMethodBuilder createAspectOfLightMethod(PsiManager manager) {
        return new LightMethodBuilder(manager, ASPECT_OF_METHOD_NAME).setModifiers(new String[]{"static", "public"}).setMethodReturnType("java.lang.Object");
    }

    @Nullable
    public static PsiClass getFactoryClass(SpringBean springBean) {
        PsiClass beanClass = null;
        if (!DomUtil.hasXml(springBean.getFactoryBean())) {
            beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(false));
        } else {
            SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
            if (factoryBeanPointer == null) {
                return null;
            }
            Object factoryBean = factoryBeanPointer.getSpringBean();
            if (!factoryBean.equals(springBean)) {
                beanClass = (PsiClass)RecursionManager.doPreventingRecursion(factoryBean, (boolean)true, () -> PsiTypesUtil.getPsiClass((PsiType)factoryBean.getBeanType(true)));
            }
        }
        if (beanClass != null && SpringFactoryBeansManager.getInstance().isFactoryBeanClass(beanClass)) {
            PsiType[] types;
            for (PsiType type : types = SpringFactoryBeansManager.getInstance().getObjectTypes((PsiType)PsiTypesUtil.getClassType((PsiClass)beanClass), springBean)) {
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return beanClass;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        SpringBean springBean;
        PsiClass psiClass;
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        if (elementName != null && elementName.length() > 0 && (psiClass = SpringBeanFactoryMethodConverterImpl.getFactoryMethodClass(springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context))) != null && !(psiClass instanceof PsiCompiledElement)) {
            return new LocalQuickFix[]{SpringBeanFactoryMethodConverterImpl.getCreateNewMethodQuickFix(springBean, psiClass, elementName)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiClass getFactoryMethodClass(SpringBean springBean) {
        SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
        if (factoryBeanPointer != null) {
            return PsiTypesUtil.getPsiClass((PsiType)factoryBeanPointer.getSpringBean().getBeanType(false));
        }
        return PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(false));
    }

    private static LocalQuickFix getCreateNewMethodQuickFix(final SpringBean springBean, final PsiClass beanClass, final String elementName) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = SpringBundle.message("model.create.factory.method.quickfix.message", SpringBeanFactoryMethodConverterImpl.getSignature(springBean, elementName));
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("model.create.factory.method.quickfix.family.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                try {
                    assert (beanClass != null);
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)beanClass.getProject()).getElementFactory();
                    @NonNls String signature = SpringBeanFactoryMethodConverterImpl.getSignature(springBean, elementName) + "{ return null; }";
                    PsiMethod method = elementFactory.createMethodFromText(signature, null);
                    beanClass.add((PsiElement)method);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NonNls
    private static String getSignature(@NotNull SpringBean springBean, @NotNull String elementName) {
        if (springBean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(5);
        }
        if (elementName == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(6);
        }
        boolean isStatic = springBean.getFactoryBean().getValue() == null;
        String params = SpringConstructorArgResolveUtil.suggestParamsForConstructorArgsAsString(springBean);
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        String returnType = psiClass == null ? "java.lang.String" : psiClass.getQualifiedName();
        return "public " + (isStatic ? "static" : "") + " " + returnType + " " + elementName + " (" + params + ")";
    }

    @NotNull
    private static SpringBean getSpringBean(ConvertContext context) {
        SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean(context);
        assert (bean != null);
        SpringBean springBean = bean;
        if (springBean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(7);
        }
        return springBean;
    }

    @Override
    protected Object[] getVariants(ConvertContext context) {
        return ArrayUtil.append((Object[])super.getVariants(context), (Object)LookupElementBuilder.create((String)ASPECT_OF_METHOD_NAME));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryMethodCandidates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parametersResolved";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryMethodCandidates";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

