/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PropertyLocalSpringBeanResolveConverter;
import com.intellij.spring.model.xml.beans.RefBase;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class PropertyLocalSpringBeanResolveConverterImpl
extends PropertyLocalSpringBeanResolveConverter {
    @Override
    @Nullable
    protected CommonSpringModel getSpringModel(ConvertContext context) {
        if (context.getModule() == null) {
            return null;
        }
        return SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel(context.getFile(), context.getModule(), Collections.emptySet());
    }

    public void bindReference(GenericDomValue<SpringBeanPointer> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget.getContainingFile() != context.getFile()) {
            RefBase ref = (RefBase)genericValue.getParent();
            assert (ref != null);
            ref.getBean().setStringValue(genericValue.getStringValue());
            genericValue.undefine();
        }
    }
}

