/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageListConverter
extends Converter<Collection<PsiPackage>>
implements CustomReferenceConverter {
    @NotNull
    public Collection<PsiPackage> fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            List<PsiPackage> list = Collections.emptyList();
            if (list == null) {
                PackageListConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (context.getXmlElement() == null) {
            List<PsiPackage> list = Collections.emptyList();
            if (list == null) {
                PackageListConverter.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (SpringConverterUtil.containsPatternReferences(s)) {
            PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getXmlElement(), context);
            Collection<PsiPackage> collection = SpringConverterUtil.getPsiPackages(references);
            if (collection == null) {
                PackageListConverter.$$$reportNull$$$0(2);
            }
            return collection;
        }
        Collection<PsiPackage> collection = SpringConverterUtil.getPackages(s, this.getDelimiters(), context.getPsiManager().getProject());
        if (collection == null) {
            PackageListConverter.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public String toString(@Nullable Collection<PsiPackage> psiPackages, ConvertContext context) {
        return null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String text = genericDomValue.getStringValue();
        if (text == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PackageListConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        GlobalSearchScope scope = context.getSearchScope();
        PsiReference[] psiReferenceArray = SpringReferenceUtils.getPsiPackagesReferences(element, text, ElementManipulators.getOffsetInElement((PsiElement)element), this.getDelimiters(), scope != null ? scope : GlobalSearchScope.allScope((Project)element.getProject()));
        if (psiReferenceArray == null) {
            PackageListConverter.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    protected String getDelimiters() {
        return ",; \n\t";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/model/converters/PackageListConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

