/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.jam.SpringJamCacheableElement;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class SpringCacheAnnotationsOnInterfaceInspection
extends SpringUastInspectionBase {
    public SpringCacheAnnotationsOnInterfaceInspection() {
        super(UClass.class, UMethod.class);
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        UClass containingClass;
        if (uMethod == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(1);
        }
        if (SpringCommonUtils.isInSpringEnabledModule((UElement)uMethod) && (containingClass = UastUtils.getContainingUClass((UElement)uMethod)) != null && containingClass.isInterface()) {
            PsiElement sourcePsi = containingClass.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
            PsiMethod method = uMethod.getJavaPsi();
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)sourcePsi.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)method)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, SpringCacheAnnotationsOnInterfaceInspection.findMetaAnnotation((UAnnotated)uMethod, "org.springframework.cache.annotation.Caching"));
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    private static UAnnotation findMetaAnnotation(UAnnotated declaration, String annotationName) {
        for (UAnnotation uAnnotation : declaration.getUAnnotations()) {
            PsiClass annotationClass = uAnnotation.resolve();
            if (annotationClass == null) continue;
            if (Objects.equals(annotationClass.getQualifiedName(), annotationName)) {
                return uAnnotation;
            }
            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)annotationClass, Collections.singletonList(annotationName))) continue;
            return uAnnotation;
        }
        return null;
    }

    private static void registerProblemIfAnnotationExists(@NotNull ProblemsHolder holder, @Nullable PsiAnnotation annotation) {
        if (holder == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(2);
        }
        SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, (UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class));
    }

    private static void registerProblemIfAnnotationExists(@NotNull ProblemsHolder holder, @Nullable UAnnotation uAnnotation) {
        PsiElement element;
        if (holder == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(3);
        }
        if ((element = UAnnotationKt.getNamePsiElement((UAnnotation)uAnnotation)) != null) {
            holder.registerProblem(element, SpringBundle.message("cacheable.should.be.defined.on.concrete.method", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uClass == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SpringCacheAnnotationsOnInterfaceInspection.$$$reportNull$$$0(5);
        }
        if (SpringCommonUtils.isInSpringEnabledModule((UElement)uClass) && uClass.isInterface() && !uClass.isAnnotationType()) {
            PsiClass aClass = uClass.getJavaPsi();
            PsiElement sourcePsi = uClass.getSourcePsi();
            if (sourcePsi == null) {
                return null;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            for (SpringJamCacheableElement cacheableElement : SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamCacheableElement.CACHEABLE_ROOT_JAM_KEY, (PsiElement)aClass)) {
                SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, cacheableElement.getAnnotation());
            }
            SpringCacheAnnotationsOnInterfaceInspection.registerProblemIfAnnotationExists(holder, SpringCacheAnnotationsOnInterfaceInspection.findMetaAnnotation((UAnnotated)uClass, "org.springframework.cache.annotation.Caching"));
            return holder.getResultsArray();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "SpringCacheAnnotationsOnInterfaceInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheAnnotationsOnInterfaceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblemIfAnnotationExists";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

