/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.actions.patterns.frameworks.FrameworkSupportProvider;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkIntegrationAction
extends AnAction
implements FrameworkSupportProvider {
    protected FrameworkIntegrationAction() {
        Presentation template = this.getTemplatePresentation();
        template.setIcon(EmptyIcon.ICON_16);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FrameworkIntegrationAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Module module = FrameworkIntegrationAction.getModule(dataContext);
        Editor editor = FrameworkIntegrationAction.getEditor(dataContext);
        XmlFile xmlFile = FrameworkIntegrationAction.getXmlFile(dataContext);
        if (module != null && editor != null && xmlFile != null) {
            this.generateSpringBeans(module, editor, xmlFile);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            FrameworkIntegrationAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        XmlFile file = FrameworkIntegrationAction.getXmlFile(dataContext);
        boolean isSpringBeanFile = file != null && SpringDomUtils.isSpringXml(file);
        boolean enabled = isSpringBeanFile && this.accept(file);
        presentation.setEnabledAndVisible(enabled);
        presentation.setText(this.getDescription());
        presentation.setIcon(this.getIcon());
    }

    @Nullable
    protected static XmlFile getXmlFile(DataContext dataContext) {
        return FrameworkIntegrationAction.getXmlFile(FrameworkIntegrationAction.getProject(dataContext), FrameworkIntegrationAction.getEditor(dataContext));
    }

    @Nullable
    protected static XmlFile getXmlFile(Project project, Editor editor) {
        if (project == null || editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    protected static Editor getEditor(DataContext dataContext) {
        return (Editor)CommonDataKeys.EDITOR.getData(dataContext);
    }

    @Nullable
    protected static Project getProject(DataContext dataContext) {
        return (Project)CommonDataKeys.PROJECT.getData(dataContext);
    }

    @Nullable
    protected static Module getModule(DataContext dataContext) {
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }

    protected boolean accept(@NotNull XmlFile file) {
        if (file == null) {
            FrameworkIntegrationAction.$$$reportNull$$$0(2);
        }
        return FrameworkIntegrationAction.acceptBeansByClassNames(file, this.getBeansClassNames());
    }

    protected String[] getBeansClassNames() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static boolean acceptBeansByClassNames(XmlFile file, String ... classNames) {
        if (classNames.length == 0) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return false;
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        SpringModel model = SpringManager.getInstance(file.getProject()).getSpringModelByFile((PsiFile)file);
        if (model != null) {
            for (String className : classNames) {
                PsiClass psiClass = javaPsiFacade.findClass(className, searchScope);
                if (psiClass == null || !SpringModelSearchers.doesBeanExist((CommonSpringModel)model, psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void generateSpringBeans(Module var1, Editor var2, XmlFile var3);

    @Nullable
    protected Icon getIcon() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/actions/patterns/frameworks/FrameworkIntegrationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

