/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.PatternIcons;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AddOpenSymphonyTimerAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String QUARTZ_ID = "quartz";

    @Override
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.scheduling.quartz.JobDetailBean"};
    }

    @Override
    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance(module.getProject()).getLibraryInfos(QUARTZ_ID);
        return new LibrariesInfo(libraryInfos, module, QUARTZ_ID);
    }

    @Override
    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo job = new TemplateInfo(module, settings.getTemplateById("quartz-job-detail"), SpringBundle.message("spring.patterns.integration.opensymphony.job.detail.bean", new Object[0]), null);
        TemplateInfo simpleTrigger = new TemplateInfo(module, settings.getTemplateById("quartz-simple-trigger"), SpringBundle.message("spring.patterns.integration.opensymphony.simple.trigger", new Object[0]), null);
        TemplateInfo cronTrigger = new TemplateInfo(module, settings.getTemplateById("quartz-cron-trigger"), SpringBundle.message("spring.patterns.integration.opensymphony.cron.trigger", new Object[0]), null, false);
        TemplateInfo sf = new TemplateInfo(module, settings.getTemplateById("quartz-scheduler-factory"), SpringBundle.message("spring.patterns.integration.opensymphony.scheduler", new Object[0]), null);
        infos.add(job);
        infos.add(simpleTrigger);
        infos.add(cronTrigger);
        infos.add(sf);
        return infos;
    }

    @Override
    public String getDescription() {
        return SpringBundle.message("spring.patterns.quartz.scheduler", new Object[0]);
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        return PatternIcons.SCHEDULER_ICON;
    }
}

