/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringObjectFactoryEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    @Override
    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor2) {
        PsiType factoryEffectiveType;
        if (bean == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(1);
        }
        if ((factoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(bean.getBeanType())) != null) {
            return processor2.process((Object)factoryEffectiveType);
        }
        return true;
    }

    @Nullable
    public static PsiType getObjectFactoryEffectiveType(@Nullable PsiType beanType) {
        if (beanType instanceof PsiClassType) {
            PsiClassType type = (PsiClassType)beanType;
            if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType(type);
            }
            if (SpringObjectFactoryEffectiveTypeProvider.isInjectProvider(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getInjectProviderType(type);
            }
        }
        return null;
    }

    public static boolean isObjectFactory(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(2);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClassType.resolve(), (String)"org.springframework.beans.factory.ObjectFactory");
    }

    public static boolean isInjectProvider(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(3);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClassType.resolve(), (String)"javax.inject.Provider");
    }

    @Nullable
    public static PsiType getInjectProviderType(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(4);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"javax.inject.Provider", (int)0, (boolean)false);
    }

    @Nullable
    public static PsiType getObjectFactoryType(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(5);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.beans.factory.ObjectFactory", (int)0, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEffectiveTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectProviderType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectFactoryType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

