/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SpringBeanFactoryAwareTypeProvider
extends SpringBeanEffectiveTypeProvider {
    @Override
    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor2) {
        PsiClass aClass;
        PsiType beanType;
        if (bean == null) {
            SpringBeanFactoryAwareTypeProvider.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            SpringBeanFactoryAwareTypeProvider.$$$reportNull$$$0(1);
        }
        if ((beanType = bean.getBeanType()) instanceof PsiClassType && (aClass = ((PsiClassType)beanType).resolve()) != null && SpringBeanFactoryAwareTypeProvider.isBeanFactoryAwareClass(aClass)) {
            for (PsiType psiType : SpringBeanFactoryAwareTypeProvider.getBeanFactoryAwareTypes(aClass)) {
                if (processor2.process((Object)psiType)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiType> getBeanFactoryAwareTypes(@NotNull PsiClass psiClass) {
        PsiMethod[] resolvableDependencies;
        if (psiClass == null) {
            SpringBeanFactoryAwareTypeProvider.$$$reportNull$$$0(2);
        }
        HashSet<PsiType> types = new HashSet<PsiType>();
        PsiClass factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("org.springframework.beans.factory.config.ConfigurableListableBeanFactory", psiClass.getResolveScope());
        if (factory != null && (resolvableDependencies = factory.findMethodsByName("registerResolvableDependency", false)).length > 0) {
            PsiMethod registerMethod = resolvableDependencies[0];
            PsiMethod[] setBeanFactoryMethods = psiClass.findMethodsByName("setBeanFactory", false);
            if (setBeanFactoryMethods.length > 0) {
                MethodReferencesSearch.search((PsiMethod)registerMethod, (SearchScope)new LocalSearchScope((PsiElement)setBeanFactoryMethods[0]), (boolean)true).forEach(psiReference -> {
                    PsiClass genericClass;
                    PsiType genericType;
                    PsiExpression dependencyTypeExpression;
                    PsiType expressionType;
                    PsiExpression[] expressions;
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (expressionType = (dependencyTypeExpression = expressions[0]).getType()) instanceof PsiClassType && (genericType = PsiUtil.substituteTypeParameter((PsiType)expressionType, (String)"java.lang.Class", (int)0, (boolean)true)) instanceof PsiClassType && (genericClass = ((PsiClassType)genericType).resolve()) != null) {
                        types.add((PsiType)PsiTypesUtil.getClassType((PsiClass)genericClass));
                    }
                });
            }
        }
        return types;
    }

    private static boolean isBeanFactoryAwareClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringBeanFactoryAwareTypeProvider.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            boolean isBeanFactory = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.BeanFactoryAware");
            return CachedValueProvider.Result.createSingleDependency((Object)isBeanFactory, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringBeanFactoryAwareTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEffectiveTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeanFactoryAwareTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isBeanFactoryAwareClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

