/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringCustomNamespaces;
import com.intellij.spring.factories.SpringFactoryBeansManagerImpl;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.index.SpringIndexUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SpringXmlBeansIndex
extends FileBasedIndexExtension<Pair<SpringBeanIndexType, String>, TIntArrayList> {
    private static final int INDEX_VERSION = 27;
    public static final ID<Pair<SpringBeanIndexType, String>, TIntArrayList> NAME = ID.create((String)"SpringXmlBeansIndex");
    private final DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> myIndexer = SpringIndexUtil::indexFile;
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        public void save(@NotNull DataOutput out, TIntArrayList values) throws IOException {
            int size;
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((size = values.size()) == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-values.getQuick(0)));
                return;
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
            for (int i = 0; i < size; ++i) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)values.getQuick(i));
            }
        }

        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            int countOrSingleValue;
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((countOrSingleValue = DataInputOutputUtil.readINT((DataInput)in)) < 0) {
                TIntArrayList result = new TIntArrayList(1);
                result.add(-countOrSingleValue);
                return result;
            }
            TIntArrayList result = new TIntArrayList(countOrSingleValue);
            for (int i = 0; i < countOrSingleValue; ++i) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/index/SpringXmlBeansIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<Pair<SpringBeanIndexType, String>, TIntArrayList> getName() {
        ID<Pair<SpringBeanIndexType, String>, TIntArrayList> iD = NAME;
        if (iD == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<Pair<SpringBeanIndexType, String>, TIntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Pair<SpringBeanIndexType, String>> getKeyDescriptor() {
        return new KeyDescriptor<Pair<SpringBeanIndexType, String>>(){

            public void save(@NotNull DataOutput out, Pair<SpringBeanIndexType, String> pair) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((SpringBeanIndexType)((Object)pair.first)).ordinal());
                if (((SpringBeanIndexType)((Object)pair.first)).key() == null) {
                    IOUtil.writeUTF((DataOutput)out, (String)((String)pair.second));
                }
            }

            public Pair<SpringBeanIndexType, String> read(@NotNull DataInput in) throws IOException {
                SpringBeanIndexType type;
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((type = SpringBeanIndexType.values()[DataInputOutputUtil.readINT((DataInput)in)]).key() != null) {
                    return type.key();
                }
                String value = IOUtil.readUTF((DataInput)in);
                return Pair.create((Object)((Object)type), (Object)value);
            }

            public int getHashCode(Pair<SpringBeanIndexType, String> value) {
                SpringBeanIndexType indexType = (SpringBeanIndexType)((Object)value.first);
                String fqn = (String)value.second;
                return 31 * indexType.ordinal() + (fqn != null ? fqn.hashCode() : 0);
            }

            public boolean isEqual(Pair<SpringBeanIndexType, String> val1, Pair<SpringBeanIndexType, String> val2) {
                if (!((SpringBeanIndexType)((Object)val1.first)).equals(val2.first)) {
                    return false;
                }
                if (((SpringBeanIndexType)((Object)val1.first)).key() != null) {
                    return true;
                }
                return Objects.equals(val1.second, val2.second);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/index/SpringXmlBeansIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        int customNamespacesVersion = 0;
        for (SpringCustomNamespaces customNamespaces : SpringCustomNamespaces.EP_NAME.getExtensionList()) {
            customNamespacesVersion += customNamespaces.getModelVersion();
            customNamespacesVersion += customNamespaces.getClass().getName().length();
        }
        return 27 + customNamespacesVersion + SpringFactoryBeansManagerImpl.getIndexingVersion();
    }

    public static boolean processBeansByClass(SpringBeanSearchParameters.BeanClass params, Processor<? super SpringBeanPointer> processor2) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)params.getPsiType());
        if (psiClass == null) {
            return true;
        }
        String psiClassFqn = Objects.requireNonNull(psiClass.getQualifiedName());
        boolean byBeanClass = SpringXmlBeansIndex.processSpringBeanPointer((Pair<SpringBeanIndexType, String>)Pair.create((Object)((Object)SpringBeanIndexType.BEAN_CLASS), (Object)psiClassFqn), params, processor2);
        if (!byBeanClass) {
            return false;
        }
        SmartList beanTypeProviderBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.BEAN_TYPE_PROVIDER.key(), params, (Processor<? super SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)beanTypeProviderBeans));
        if (beanTypeProviderBeans.isEmpty()) {
            return true;
        }
        return ContainerUtil.process((List)beanTypeProviderBeans, pointer -> {
            if (!Comparing.equal((Object)psiClass, (Object)pointer.getBeanClass())) {
                return true;
            }
            return processor2.process(pointer);
        });
    }

    public static boolean processBeansByName(SpringBeanSearchParameters.BeanName params, Processor<? super SpringBeanPointer> processor2) {
        String beanName = params.getBeanName();
        boolean processByName = SpringXmlBeansIndex.processSpringBeanPointer((Pair<SpringBeanIndexType, String>)Pair.create((Object)((Object)SpringBeanIndexType.BEAN_NAME), (Object)beanName), params, processor2);
        if (!processByName) {
            return false;
        }
        SmartList beanNameProviderBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.BEAN_NAME_PROVIDER.key(), params, (Processor<? super SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)beanNameProviderBeans));
        if (beanNameProviderBeans.isEmpty()) {
            return true;
        }
        return ContainerUtil.process((List)beanNameProviderBeans, pointer -> {
            if (!Objects.equals(beanName, pointer.getName())) {
                return true;
            }
            return processor2.process(pointer);
        });
    }

    public static boolean processComponentScans(SpringBeanSearchParameters.BeanName params, Processor<? super SpringBeanPointer> processor2) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.COMPONENT_SCAN.key(), params, processor2);
    }

    public static boolean processFactoryBeans(SpringBeanSearchParameters params, Processor<? super SpringBeanPointer> processor2) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_BEAN.key(), params, processor2);
    }

    public static boolean processFactoryBeanClasses(SpringBeanSearchParameters params, Processor<? super SpringBeanPointer> processor2) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_BEAN_CLASS.key(), params, processor2);
    }

    public static boolean processFactoryMethods(SpringBeanSearchParameters params, Processor<? super SpringBeanPointer> processor2) {
        return SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.FACTORY_METHOD.key(), params, processor2);
    }

    public static boolean processAbstractBeans(SpringBeanSearchParameters params, Processor<? super SpringBeanPointer> processor2) {
        SmartList abstractBeans = new SmartList();
        SpringXmlBeansIndex.processSpringBeanPointer(SpringBeanIndexType.ABSTRACT_BEAN.key(), params, (Processor<? super SpringBeanPointer>)new CommonProcessors.CollectProcessor((Collection)abstractBeans));
        return ContainerUtil.process((List)abstractBeans, processor2);
    }

    public static boolean processAliases(SpringBeanSearchParameters.BeanName params, final Processor<? super Alias> processor2) {
        Pair key = Pair.create((Object)((Object)SpringBeanIndexType.ALIAS), (Object)params.getBeanName());
        MultiMap<VirtualFile, TIntArrayList> results = SpringXmlBeansIndex.getResults((Pair<SpringBeanIndexType, String>)key, params);
        if (results.isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                if (domElement == null) {
                    3.$$$reportNull$$$0(0);
                }
                return !(domElement instanceof Alias) || processor2.process((Object)((Alias)domElement));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$3", "processDomElement"));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    public static boolean processCustomBeans(SpringBeanSearchParameters params, final Processor<? super CustomBeanWrapper> processor2) {
        Pair<SpringBeanIndexType, String> key = SpringBeanIndexType.CUSTOM_BEAN_WRAPPER.key();
        MultiMap<VirtualFile, TIntArrayList> results = SpringXmlBeansIndex.getResults(key, params);
        if (results.isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                if (domElement == null) {
                    4.$$$reportNull$$$0(0);
                }
                return !(domElement instanceof CustomBeanWrapper) || processor2.process((Object)((CustomBeanWrapper)domElement));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$4", "processDomElement"));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    private static boolean processSpringBeanPointer(@NotNull Pair<SpringBeanIndexType, String> key, @NotNull SpringBeanSearchParameters params, final @NotNull Processor<? super SpringBeanPointer> processor2) {
        MultiMap<VirtualFile, TIntArrayList> results;
        if (key == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(3);
        }
        if (params == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(5);
        }
        if ((results = SpringXmlBeansIndex.getResults(key, params)).isEmpty()) {
            return true;
        }
        DomElementProcessor domElementProcessor = new DomElementProcessor(){

            @Override
            protected boolean processDomElement(@NotNull DomElement domElement) {
                SpringBeanPointer<?> pointer;
                if (domElement == null) {
                    5.$$$reportNull$$$0(0);
                }
                return !(domElement instanceof DomSpringBean) || processor2.process(pointer = BeanService.getInstance().createSpringBeanPointer((DomSpringBean)domElement));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/index/SpringXmlBeansIndex$5", "processDomElement"));
            }
        };
        return SpringXmlBeansIndex.processDomElements(params.getProject(), results, domElementProcessor);
    }

    @NotNull
    private static MultiMap<VirtualFile, TIntArrayList> getResults(@NotNull Pair<SpringBeanIndexType, String> key, @NotNull SpringBeanSearchParameters params) {
        if (key == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(6);
        }
        if (params == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(7);
        }
        MultiMap results = new MultiMap();
        FileBasedIndex.getInstance().processValues(NAME, key, params.getVirtualFile(), (file, value) -> {
            results.putValue((Object)file, value);
            return true;
        }, params.getSearchScope());
        MultiMap multiMap = results;
        if (multiMap == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private static boolean processDomElements(@NotNull Project project, @NotNull MultiMap<VirtualFile, TIntArrayList> indexMap, @NotNull DomElementProcessor processor2) {
        if (project == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(9);
        }
        if (indexMap == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            SpringXmlBeansIndex.$$$reportNull$$$0(11);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        DomManager domManager = DomManager.getDomManager((Project)project);
        for (Map.Entry entry : indexMap.entrySet()) {
            VirtualFile file = (VirtualFile)entry.getKey();
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof XmlFile)) continue;
            TIntProcedure procedure = value -> {
                PsiElement psiElement = psiFile.findElementAt(value);
                XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class, (boolean)false);
                DomElement domElement = domManager.getDomElement(xmlTag);
                if (domElement == null) {
                    return true;
                }
                return processor2.processDomElement(domElement);
            };
            for (TIntArrayList values : (Collection)entry.getValue()) {
                if (values.forEach(procedure)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/index/SpringXmlBeansIndex";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/index/SpringXmlBeansIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSpringBeanPointer";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDomElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class DomElementProcessor {
        private DomElementProcessor() {
        }

        protected abstract boolean processDomElement(@NotNull DomElement var1);
    }
}

