/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.index;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringIndexUtil {
    SpringIndexUtil() {
    }

    @NotNull
    static Map<Pair<SpringBeanIndexType, String>, TIntArrayList> indexFile(FileContent content) {
        List<SpringBeanIndexInfo> infos = SpringIndexUtil.getAllBeanInfos(content);
        if (infos.isEmpty()) {
            Map<Pair<SpringBeanIndexType, String>, TIntArrayList> map = Collections.emptyMap();
            if (map == null) {
                SpringIndexUtil.$$$reportNull$$$0(0);
            }
            return map;
        }
        HashMap<Pair<SpringBeanIndexType, String>, TIntArrayList> valueMap = new HashMap<Pair<SpringBeanIndexType, String>, TIntArrayList>();
        for (SpringBeanIndexInfo info : infos) {
            SpringBeanType type = info.getType();
            int offset = info.getOffset();
            if (type == SpringBeanType.ALIAS) {
                SpringIndexUtil.addKeyedValue(valueMap, SpringBeanIndexType.ALIAS, info.getId(), offset);
                continue;
            }
            SpringIndexUtil.addKeyedValue(valueMap, SpringBeanIndexType.BEAN_NAME, info.getId(), offset);
            for (String alias : info.getAliases()) {
                SpringIndexUtil.addKeyedValue(valueMap, SpringBeanIndexType.BEAN_NAME, alias, offset);
            }
            if (type == SpringBeanType.SIMPLE || type == SpringBeanType.CUSTOM) {
                SpringIndexUtil.addKeyedValue(valueMap, SpringBeanIndexType.BEAN_CLASS, info.getFqn(), offset);
            }
            if (type == SpringBeanType.BEAN_TYPE_PROVIDER) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.BEAN_TYPE_PROVIDER.key(), offset);
                continue;
            }
            if (type == SpringBeanType.BEAN_NAME_PROVIDER) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.BEAN_NAME_PROVIDER.key(), offset);
                continue;
            }
            if (type == SpringBeanType.COMPONENT_SCAN) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.COMPONENT_SCAN.key(), offset);
                continue;
            }
            if (type == SpringBeanType.FACTORY_BEAN) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.FACTORY_BEAN.key(), offset);
                continue;
            }
            if (type == SpringBeanType.FACTORY_BEAN_CLASS) {
                SpringIndexUtil.addKeyedValue(valueMap, SpringBeanIndexType.BEAN_CLASS, info.getFqn(), offset);
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.FACTORY_BEAN_CLASS.key(), offset);
                continue;
            }
            if (type == SpringBeanType.FACTORY_METHOD) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.FACTORY_METHOD.key(), offset);
                continue;
            }
            if (type == SpringBeanType.CUSTOM_BEAN_WRAPPER) {
                SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.CUSTOM_BEAN_WRAPPER.key(), offset);
                continue;
            }
            if (type != SpringBeanType.ABSTRACT_BEAN) continue;
            SpringIndexUtil.storeValue(valueMap, SpringBeanIndexType.ABSTRACT_BEAN.key(), offset);
        }
        HashMap<Pair<SpringBeanIndexType, String>, TIntArrayList> hashMap = valueMap;
        if (hashMap == null) {
            SpringIndexUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void addKeyedValue(@NotNull Map<Pair<SpringBeanIndexType, String>, TIntArrayList> map, @NotNull SpringBeanIndexType type, @Nullable String key, int offset) {
        if (map == null) {
            SpringIndexUtil.$$$reportNull$$$0(2);
        }
        if (type == null) {
            SpringIndexUtil.$$$reportNull$$$0(3);
        }
        if (key == null) {
            return;
        }
        Pair indexKey = Pair.create((Object)((Object)type), (Object)key);
        SpringIndexUtil.storeValue(map, (Pair<SpringBeanIndexType, String>)indexKey, offset);
    }

    private static void storeValue(Map<Pair<SpringBeanIndexType, String>, TIntArrayList> map, Pair<SpringBeanIndexType, String> indexKey, int offset) {
        TIntArrayList values = map.get(indexKey);
        if (values == null) {
            values = new TIntArrayList(1);
            map.put(indexKey, values);
        }
        values.add(offset);
    }

    @NotNull
    private static List<SpringBeanIndexInfo> getAllBeanInfos(FileContent content) {
        CharSequence text = content.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"http://www.springframework.org/", (int)0) == -1 || CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"<beans", (int)0) == -1 && CharArrayUtil.indexOf((CharSequence)text, (CharSequence)":beans", (int)0) == -1) {
            List<SpringBeanIndexInfo> list = Collections.emptyList();
            if (list == null) {
                SpringIndexUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiFile file = content.getPsiFile();
        if (!(file instanceof XmlFile)) {
            List<SpringBeanIndexInfo> list = Collections.emptyList();
            if (list == null) {
                SpringIndexUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        DomFileElement<Beans> fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
        if (fileElement == null) {
            List<SpringBeanIndexInfo> list = Collections.emptyList();
            if (list == null) {
                SpringIndexUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<SpringBeanIndexInfo> allBeans = new ArrayList<SpringBeanIndexInfo>();
        SpringIndexUtil.processChildren(fileElement.getRootElement(), allBeans);
        ArrayList<SpringBeanIndexInfo> arrayList = allBeans;
        if (arrayList == null) {
            SpringIndexUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void processChildren(@NotNull DomElement parent, List<SpringBeanIndexInfo> allInfos) {
        if (parent == null) {
            SpringIndexUtil.$$$reportNull$$$0(8);
        }
        List children = DomUtil.getDefinedChildren((DomElement)parent, (boolean)true, (boolean)false);
        for (DomElement element : children) {
            if (element instanceof DomSpringBean) {
                if (element instanceof CustomBeanWrapper) {
                    SpringIndexUtil.indexCustomBeanWrapper((CustomBeanWrapper)element, allInfos);
                    continue;
                }
                SpringBeanIndexInfo info = new SpringBeanIndexInfo(SpringIndexUtil.getOffset(element));
                allInfos.add(info);
                DomSpringBean domSpringBean = (DomSpringBean)element;
                SpringIndexUtil.setBeanName(domSpringBean, info, allInfos);
                SpringIndexUtil.setBeanClassName(domSpringBean, info);
                info.setAliases(domSpringBean.getAliases());
            } else if (element instanceof Alias) {
                String aliasName = ((Alias)element).getAlias().getRawText();
                if (!StringUtil.isNotEmpty((String)aliasName)) continue;
                SpringBeanIndexInfo info = new SpringBeanIndexInfo(SpringIndexUtil.getOffset(element));
                info.setType(SpringBeanType.ALIAS);
                info.setId(aliasName);
                allInfos.add(info);
                continue;
            }
            SpringIndexUtil.processChildren(element, allInfos);
        }
    }

    private static void setBeanName(DomSpringBean bean, SpringBeanIndexInfo existing, List<SpringBeanIndexInfo> allInfos) {
        BeanName beanName = (BeanName)DomReflectionUtil.findAnnotationDFS(bean.getClass(), BeanName.class);
        if (beanName == null) {
            existing.setId(bean.getBeanName());
            return;
        }
        if (beanName.displayOnly()) {
            return;
        }
        String name = beanName.value();
        if (!name.isEmpty()) {
            assert (beanName.provider() == BeanNameProvider.class) : bean.getDomElementType();
            existing.setId(name);
            return;
        }
        assert (beanName.provider() != BeanNameProvider.class) : bean.getDomElementType();
        SpringBeanIndexInfo beanNameProviderInfo = new SpringBeanIndexInfo(existing.getOffset());
        beanNameProviderInfo.setType(SpringBeanType.BEAN_NAME_PROVIDER);
        allInfos.add(beanNameProviderInfo);
    }

    private static int getOffset(DomElement element) {
        XmlElement xmlElement = element.getXmlElement();
        assert (xmlElement != null) : element;
        return xmlElement.getTextOffset();
    }

    private static void indexCustomBeanWrapper(@NotNull CustomBeanWrapper wrapper, @NotNull List<SpringBeanIndexInfo> allBeans) {
        XmlTag tag;
        if (wrapper == null) {
            SpringIndexUtil.$$$reportNull$$$0(9);
        }
        if (allBeans == null) {
            SpringIndexUtil.$$$reportNull$$$0(10);
        }
        if ((tag = wrapper.getXmlTag()) != null) {
            SpringBeanIndexInfo info = new SpringBeanIndexInfo(tag.getTextOffset());
            info.setType(SpringBeanType.CUSTOM_BEAN_WRAPPER);
            allBeans.add(info);
        }
    }

    private static void setBeanClassName(@NotNull DomSpringBean bean, @NotNull SpringBeanIndexInfo info) {
        if (bean == null) {
            SpringIndexUtil.$$$reportNull$$$0(11);
        }
        if (info == null) {
            SpringIndexUtil.$$$reportNull$$$0(12);
        }
        if (bean instanceof SpringBean) {
            SpringBean springBean = (SpringBean)bean;
            GenericAttributeValue<PsiClass> clazzAttrValue = springBean.getClazz();
            if (DomUtil.hasXml(clazzAttrValue)) {
                String fqn = StringUtil.notNullize((String)clazzAttrValue.getRawText()).replace('$', '.');
                info.setFqn(fqn);
                if (DomUtil.hasXml(springBean.getFactoryMethod())) {
                    info.setType(SpringBeanType.FACTORY_METHOD);
                }
            } else if (DomUtil.hasXml(springBean.getFactoryBean())) {
                info.setType(SpringBeanType.FACTORY_BEAN);
            } else if (DomUtil.hasXml(springBean.getParentBean())) {
                info.setType(SpringBeanType.ABSTRACT_BEAN);
            }
        } else if (bean instanceof SpringBeansPackagesScanBean) {
            info.setType(SpringBeanType.COMPONENT_SCAN);
        } else {
            BeanType beanType = (BeanType)DomReflectionUtil.findAnnotationDFS(bean.getClass(), BeanType.class);
            if (beanType != null) {
                String className = beanType.value();
                if (!className.isEmpty()) {
                    assert (beanType.provider() == BeanTypeProvider.class) : bean.getDomElementType();
                    info.setFqn(className);
                    info.setType(SpringBeanType.CUSTOM);
                } else {
                    assert (beanType.provider() != BeanTypeProvider.class) : bean.getDomElementType();
                    info.setType(SpringBeanType.BEAN_TYPE_PROVIDER);
                }
            }
        }
        if (SpringIndexUtil.isFactoryBeanCandidateClass(info)) {
            info.setType(SpringBeanType.FACTORY_BEAN_CLASS);
        }
    }

    private static boolean isFactoryBeanCandidateClass(@NotNull SpringBeanIndexInfo info) {
        SpringBeanType type;
        if (info == null) {
            SpringIndexUtil.$$$reportNull$$$0(13);
        }
        if ((type = info.getType()) == SpringBeanType.SIMPLE || type == SpringBeanType.CUSTOM) {
            String fqn = info.getFqn();
            return fqn != null && (SpringFactoryBeansManager.getInstance().isKnownBeanFactory(fqn) || StringUtil.endsWith((CharSequence)fqn, (CharSequence)"FactoryBean"));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/index/SpringIndexUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFile";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/index/SpringIndexUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addKeyedValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexCustomBeanWrapper";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBeanClassName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFactoryBeanCandidateClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SpringBeanIndexInfo {
        private final int offset;
        private SpringBeanType myType = SpringBeanType.SIMPLE;
        private String id;
        private String fqn;
        private String[] aliases = ArrayUtilRt.EMPTY_STRING_ARRAY;

        private SpringBeanIndexInfo(int offset) {
            this.offset = offset;
        }

        private String[] getAliases() {
            return this.aliases;
        }

        private void setAliases(String[] aliases) {
            this.aliases = aliases;
        }

        private int getOffset() {
            return this.offset;
        }

        private String getId() {
            return this.id;
        }

        private void setId(String id) {
            this.id = id;
        }

        private String getFqn() {
            return this.fqn;
        }

        private void setFqn(String fqn) {
            this.fqn = fqn;
        }

        private SpringBeanType getType() {
            return this.myType;
        }

        private void setType(SpringBeanType type) {
            this.myType = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringBeanIndexInfo info = (SpringBeanIndexInfo)o;
            if (this.myType != info.myType) {
                return false;
            }
            if (this.offset != info.offset) {
                return false;
            }
            if (this.id != null ? !this.id.equals(info.id) : info.id != null) {
                return false;
            }
            if (this.fqn != null ? !this.fqn.equals(info.fqn) : info.fqn != null) {
                return false;
            }
            return Arrays.equals(this.aliases, info.aliases);
        }

        public int hashCode() {
            int result = this.offset;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
            result = 31 * result + (this.fqn != null ? this.fqn.hashCode() : 0);
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    static enum SpringBeanType {
        SIMPLE,
        FACTORY_METHOD,
        FACTORY_BEAN,
        FACTORY_BEAN_CLASS,
        CUSTOM,
        CUSTOM_BEAN_WRAPPER,
        COMPONENT_SCAN,
        ALIAS,
        BEAN_TYPE_PROVIDER,
        ABSTRACT_BEAN,
        BEAN_NAME_PROVIDER;

    }
}

