/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.AnnotationSpringModelImpl;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.contexts.model.XmlSpringModelImpl;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCombinedModelFactory {
    @Nullable
    public static SpringModel createModel(@Nullable SpringFileSet set, @NotNull Module module) {
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(0);
        }
        LinkedHashSet<AnnotationSpringModelImpl> mixed = new LinkedHashSet<AnnotationSpringModelImpl>(2);
        List<XmlFile> xmlConfigs = SpringCombinedModelFactory.getXmlConfigs(set, module.getProject());
        Set<PsiClass> codeConfigurations = SpringCombinedModelFactory.getCodeConfigs(set, module.getProject());
        if (!xmlConfigs.isEmpty()) {
            XmlSpringModel xmlModel = SpringCombinedModelFactory.createXmlModel(xmlConfigs, module, set);
            if (codeConfigurations.isEmpty()) {
                return xmlModel;
            }
            ContainerUtil.addIfNotNull(mixed, (Object)xmlModel);
        }
        if (!codeConfigurations.isEmpty()) {
            AnnotationSpringModelImpl annotationSpringModel = new AnnotationSpringModelImpl(codeConfigurations, module, set);
            if (xmlConfigs.isEmpty()) {
                return annotationSpringModel;
            }
            mixed.add(annotationSpringModel);
        }
        return new CombinedSpringModelImpl(mixed, module, set);
    }

    @NotNull
    private static List<XmlFile> getXmlConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(1);
        }
        if (set == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                SpringCombinedModelFactory.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<XmlFile> xmlConfigs = new ArrayList<XmlFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFilePointer pointer : set.getXmlFiles()) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            xmlConfigs.add((XmlFile)psiFile);
        }
        ArrayList<XmlFile> arrayList = xmlConfigs;
        if (arrayList == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static Set<PsiClass> getCodeConfigs(@Nullable SpringFileSet set, @NotNull Project project) {
        if (project == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(4);
        }
        if (set == null) {
            Set<PsiClass> set2 = Collections.emptySet();
            if (set2 == null) {
                SpringCombinedModelFactory.$$$reportNull$$$0(5);
            }
            return set2;
        }
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFilePointer pointer : set.getCodeConfigurationFiles()) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof PsiClassOwner)) continue;
            configurations.addAll(SpringCombinedModelFactory.getConfigurationPsiClasses((PsiClassOwner)psiFile));
        }
        LinkedHashSet<PsiClass> linkedHashSet = configurations;
        if (linkedHashSet == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static void addConfigurations(@NotNull Set<PsiClass> configurations, @NotNull PsiClass psiClass) {
        if (configurations == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(8);
        }
        if (configurations.contains(psiClass)) {
            return;
        }
        configurations.add(psiClass);
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!SpringCommonUtils.isConfigurationOrMeta(innerClass)) continue;
            SpringCombinedModelFactory.addConfigurations(configurations, innerClass);
        }
    }

    @Nullable
    public static XmlSpringModel createXmlModel(Collection<XmlFile> configs, Module module, @NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(9);
        }
        return SpringCombinedModelFactory.createXmlModel(configs, module, null, (NullableFactory<Set<String>>)((NullableFactory)() -> activeProfiles));
    }

    @Nullable
    private static XmlSpringModel createXmlModel(Collection<XmlFile> configs, Module module, @Nullable SpringFileSet set) {
        return SpringCombinedModelFactory.createXmlModel(configs, module, set, (NullableFactory<Set<String>>)((NullableFactory)() -> set == null ? null : set.getActiveProfiles()));
    }

    @Nullable
    private static XmlSpringModel createXmlModel(@NotNull Collection<XmlFile> configs, @NotNull Module module, @Nullable SpringFileSet set, final @NotNull NullableFactory<Set<String>> activeProfilesFactory) {
        if (configs == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(10);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(11);
        }
        if (activeProfilesFactory == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(12);
        }
        LinkedHashSet<XmlFile> files = new LinkedHashSet<XmlFile>(configs.size());
        for (XmlFile psiFile : configs) {
            if (!SpringDomUtils.isSpringXml(psiFile)) continue;
            files.add(psiFile);
        }
        if (files.isEmpty()) {
            return null;
        }
        return new XmlSpringModelImpl(files, module, set){

            @Override
            public Set<String> getActiveProfiles() {
                return (Set)activeProfilesFactory.create();
            }
        };
    }

    @Nullable
    static SpringModel createSingleModel(@NotNull PsiFile psiFile, @NotNull Module module) {
        PsiFile originalFile;
        if (psiFile == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(13);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(14);
        }
        if ((originalFile = psiFile.getOriginalFile()) instanceof XmlFile) {
            return SpringCombinedModelFactory.createSingleXmlModel((XmlFile)originalFile, module);
        }
        if (originalFile instanceof PsiClassOwner) {
            return SpringCombinedModelFactory.createSingleAnnotationModel((PsiClassOwner)originalFile, module);
        }
        return null;
    }

    @Nullable
    private static SpringModel createSingleXmlModel(@NotNull XmlFile psiFile, @NotNull Module module) {
        if (psiFile == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(15);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(16);
        }
        if (module.isDisposed()) {
            return null;
        }
        if (!SpringDomUtils.isSpringXml(psiFile)) {
            return null;
        }
        return new XmlSpringModelImpl(Collections.singleton(psiFile), module, null);
    }

    @Nullable
    private static SpringModel createSingleAnnotationModel(@NotNull PsiClassOwner psiClassOwner, @NotNull Module module) {
        Set<PsiClass> configurations;
        if (psiClassOwner == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(17);
        }
        if (module == null) {
            SpringCombinedModelFactory.$$$reportNull$$$0(18);
        }
        if ((configurations = SpringCombinedModelFactory.getConfigurationPsiClasses(psiClassOwner)).isEmpty()) {
            return null;
        }
        return new AnnotationSpringModelImpl(configurations, module, null);
    }

    private static Set<PsiClass> getConfigurationPsiClasses(PsiClassOwner psiClassOwner) {
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        PsiClass[] classes = psiClassOwner.getClasses();
        if (classes.length == 1) {
            SpringCombinedModelFactory.addConfigurations(configurations, classes[0]);
        } else {
            for (PsiClass psiClass : classes) {
                if (!SpringCommonUtils.isConfigurationOrMeta(psiClass)) continue;
                SpringCombinedModelFactory.addConfigurations(configurations, psiClass);
            }
        }
        return configurations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringCombinedModelFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfilesFactory";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringCombinedModelFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlConfigs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getXmlConfigs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCodeConfigs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurations";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createXmlModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSingleModel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSingleXmlModel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSingleAnnotationModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

