/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScans;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastUtils;

public class SpringComponentScanAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringComponentScanAnnotator";
    }

    public String getName() {
        return SpringBundle.message("spring.core.component.scan.annotator.name", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.Gutter.SpringScan;
    }

    @Override
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        UElement uAnnotation;
        if (psiElement == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(1);
        }
        if (!((uAnnotation = UAnnotationUtils.getUParentForAnnotationIdentifier((PsiElement)psiElement)) instanceof UAnnotation)) {
            return;
        }
        UAnnotation element = (UAnnotation)uAnnotation;
        SpringComponentScanAnnotator.annotateComponentScan(element, result);
        SpringComponentScanAnnotator.annotateComponentScans(element, result);
    }

    private static boolean isComponentScanAnno(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(2);
        }
        if (!SpringComponentScanAnnotator.isClassLevelAnnotation(psiAnnotation)) {
            return false;
        }
        if ("org.springframework.context.annotation.ComponentScan".equals(psiAnnotation.getQualifiedName())) {
            return true;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class);
        return psiClass != null && JamService.getJamService((Project)psiAnnotation.getProject()).getJamElement(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    private static void annotateComponentScans(@NotNull UAnnotation uAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiAnnotation psiAnnotation;
        if (uAnnotation == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(4);
        }
        if ((psiAnnotation = (PsiAnnotation)UElementKt.getAsJavaPsiElement((UElement)uAnnotation, PsiAnnotation.class)) == null) {
            return;
        }
        UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uAnnotation, UDeclaration.class);
        PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        PsiElement identifier = UAnnotationKt.getNamePsiElement((UAnnotation)uAnnotation);
        if (identifier == null) {
            return;
        }
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        SpringJamComponentScans springJamComponentScans = (SpringJamComponentScans)service.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringJamComponentScans.META});
        if (springJamComponentScans != null) {
            for (SpringComponentScan springComponentScan : springJamComponentScans.getComponentScans()) {
                if (!psiAnnotation.equals(springComponentScan.getAnnotation())) continue;
                SpringComponentScanAnnotator.annotateSpringBeansPackagesScan(result, identifier, springComponentScan);
            }
        }
    }

    private static void annotateComponentScan(@NotNull UAnnotation uAnnotation, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        PsiAnnotation element;
        if (uAnnotation == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(5);
        }
        if (result == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(6);
        }
        if ((element = (PsiAnnotation)UElementKt.getAsJavaPsiElement((UElement)uAnnotation, PsiAnnotation.class)) == null || !SpringComponentScanAnnotator.isComponentScanAnno(element)) {
            return;
        }
        UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uAnnotation, UDeclaration.class);
        PsiClass owner = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uDeclaration, PsiClass.class);
        PsiElement identifier = UAnnotationKt.getNamePsiElement((UAnnotation)uAnnotation);
        if (identifier == null) {
            return;
        }
        if (owner != null) {
            PsiAnnotation psiAnnotation;
            List<? extends SpringBeansPackagesScan> allScans = SpringJamUtils.getInstance().getBeansPackagesScan(owner);
            List scans = allScans.stream().filter(scan -> scan instanceof SpringComponentScan && element.equals(((SpringComponentScan)scan).getAnnotation())).map(scan -> (SpringComponentScan)scan).collect(Collectors.toList());
            SpringComponentScan scan2 = (SpringComponentScan)ContainerUtil.getFirstItem(scans);
            PsiAnnotation psiAnnotation2 = psiAnnotation = scan2 == null ? null : scan2.getAnnotation();
            if (psiAnnotation != null) {
                SpringComponentScanAnnotator.annotateSpringBeansPackagesScan(result, identifier, psiAnnotation, scans);
            }
        }
    }

    private static boolean isClassLevelAnnotation(PsiAnnotation psiElement) {
        PsiElement parent = psiElement.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiClass;
    }

    private static void annotateSpringBeansPackagesScan(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull PsiElement identifier, SpringComponentScan scan) {
        PsiAnnotation psiAnnotation;
        if (result == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(7);
        }
        if (identifier == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(8);
        }
        if ((psiAnnotation = scan.getAnnotation()) == null) {
            return;
        }
        SpringComponentScanAnnotator.annotateSpringBeansPackagesScan(result, identifier, psiAnnotation, (List<? extends SpringComponentScan>)new SmartList((Object)scan));
    }

    private static void annotateSpringBeansPackagesScan(@NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull PsiElement identifier, final PsiAnnotation psiAnnotation, final List<? extends SpringComponentScan> scans) {
        if (result == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(9);
        }
        if (identifier == null) {
            SpringComponentScanAnnotator.$$$reportNull$$$0(10);
        }
        SpringComponentScanAnnotator.addSpringJavaBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

            @NotNull
            protected Collection<? extends CommonModelElement> compute() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiAnnotation);
                if (module == null) {
                    Set set = Collections.emptySet();
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                Set scannedElements = scans.stream().flatMap(scan -> scan.getScannedElements(module).stream()).collect(Collectors.toSet());
                ArrayList<SpringBeanPointer> beans = new ArrayList<SpringBeanPointer>(BeanService.getInstance().mapSpringBeans(scannedElements));
                beans.sort(SpringBeanPointer.DISPLAY_COMPARATOR);
                List list = ContainerUtil.map(beans, SpringBeanPointer.TO_BEAN);
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringComponentScanAnnotator$1", "compute"));
            }
        }, SpringApiIcons.Gutter.SpringScan);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uAnnotation";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/gutter/SpringComponentScanAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isComponentScanAnno";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateComponentScans";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateComponentScan";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateSpringBeansPackagesScan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

