/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.gutter.DomElementListCellRenderer;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.DomElement;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SpringBeansPsiElementCellRenderer
extends DefaultPsiElementCellRenderer {
    public static final PsiElementListCellRenderer<PsiElement> INSTANCE = new SpringBeansPsiElementCellRenderer();
    private static final DomElementListCellRenderer DOM_RENDERER = new DomElementListCellRenderer(SpringApiBundle.message("spring.bean.with.unknown.name", new Object[0])){

        @Override
        public String getElementText(PsiElement element) {
            DomElement domElement = 1.getDomElement(element);
            if (domElement instanceof DomSpringBean) {
                return SpringPresentationProvider.getSpringBeanName((DomSpringBean)domElement);
            }
            return super.getElementText(element);
        }

        @Override
        protected Icon getIcon(PsiElement element) {
            return SpringPresentationProvider.getSpringIcon(1.getDomElement(element));
        }
    };

    public String getElementText(PsiElement element) {
        PsiMember member;
        PsiElement psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element);
        if (psiElement instanceof XmlTag) {
            return DOM_RENDERER.getElementText(psiElement);
        }
        @Nullable CommonSpringBean springBean = psiElement instanceof PsiAnnotation ? ((member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class)) == null ? null : SpringBeansPsiElementCellRenderer.getJamBean(member)) : SpringBeanPomTargetUtils.getSpringBean(element);
        if (springBean != null) {
            return SpringPresentationProvider.getSpringBeanName(springBean);
        }
        return super.getElementText(psiElement);
    }

    private static PsiElement getElementToProcess(PsiElement element) {
        PomTarget target;
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getNavigationElement();
        }
        return element;
    }

    public String getContainerText(PsiElement element, String name) {
        PsiClass psiClass;
        PsiElement psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element);
        if (psiElement instanceof XmlTag) {
            return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath(psiElement);
        }
        if (psiElement instanceof PsiAnnotation && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && psiClass.getName() != null) {
            return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath((PsiElement)psiClass);
        }
        return SpringBeansPsiElementCellRenderer.getUniqueVirtualFilePath(element);
    }

    private static String getUniqueVirtualFilePath(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        return "(" + UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(psiElement.getProject(), virtualFile) + ")";
    }

    @Nullable
    protected Icon getIcon(PsiElement element) {
        CommonSpringBean bean;
        PsiElement psiElement = SpringBeansPsiElementCellRenderer.getElementToProcess(element);
        if (psiElement instanceof XmlTag) {
            return DOM_RENDERER.getIcon(psiElement);
        }
        if (psiElement instanceof PsiAnnotation) {
            JamPsiMemberSpringBean springBean;
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
            JamPsiMemberSpringBean jamPsiMemberSpringBean = springBean = member == null ? null : SpringBeansPsiElementCellRenderer.getJamBean(member);
            if (springBean != null) {
                return SpringApiIcons.SpringJavaBean;
            }
        } else if (!DumbService.isDumb((Project)element.getProject()) && (bean = SpringBeanPomTargetUtils.getSpringBean(element)) != null) {
            return SpringPresentationProvider.getSpringIcon(bean);
        }
        return super.getIcon(psiElement);
    }

    private static JamPsiMemberSpringBean getJamBean(PsiMember member) {
        return (JamPsiMemberSpringBean)JamService.getJamService((Project)member.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)member);
    }
}

