/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.facet.SpringFrameworkDetector;
import com.intellij.spring.facet.validation.SpringConfigurationCheckTask;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

final class SpringConfigurationCheckStartupActivity
implements StartupActivity {
    SpringConfigurationCheckStartupActivity() {
    }

    public void runActivity(final @NotNull Project project) {
        Application application;
        if (project == null) {
            SpringConfigurationCheckStartupActivity.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (DetectionExcludesConfiguration.getInstance((Project)project).isExcludedFromDetection(SpringFrameworkDetector.getSpringFrameworkType())) {
                return;
            }
            if (!SpringCommonUtils.hasSpringFacets(project) && !SpringLibraryUtil.hasSpringLibrary(project)) {
                return;
            }
            if (ProjectInspectionProfileManager.getInstance((Project)project).isCurrentProfileInitialized()) {
                SpringConfigurationCheckStartupActivity.queueTask(project);
                return;
            }
            project.getMessageBus().connect().subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

                public void profilesInitialized() {
                    SpringConfigurationCheckStartupActivity.queueTask(project);
                }
            });
        }).inSmartMode(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static void queueTask(Project project) {
        ApplicationManager.getApplication().invokeLater(() -> new SpringConfigurationCheckTask(project).queue(), project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/facet/validation/SpringConfigurationCheckStartupActivity", "runActivity"));
    }
}

