/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FilesetContainsConfigFilesInTestsSourceValidator
extends FacetEditorValidator {
    private static final int MAX_FILES_TO_SHOW = 5;
    private final Module myModule;
    private final Set<? extends SpringFileSet> myFileSets;

    public FilesetContainsConfigFilesInTestsSourceValidator(Module module, Set<? extends SpringFileSet> fileSets) {
        this.myModule = module;
        this.myFileSets = fileSets;
    }

    @NotNull
    public ValidationResult check() {
        Project project = this.myModule.getProject();
        if (DumbService.isDumb((Project)project)) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FilesetContainsConfigFilesInTestsSourceValidator.$$$reportNull$$$0(0);
            }
            return validationResult;
        }
        ModuleFileIndex index = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
        LinkedHashSet<VirtualFile> inTestSourceRoots = new LinkedHashSet<VirtualFile>();
        for (SpringFileSet springFileSet : this.myFileSets) {
            Iterable configFiles = ContainerUtil.concat(springFileSet.getXmlFiles(), springFileSet.getCodeConfigurationFiles());
            for (VirtualFilePointer pointer : configFiles) {
                VirtualFile file = pointer.isValid() ? pointer.getFile() : null;
                if (file == null || !index.isInTestSourceContent(file)) continue;
                inTestSourceRoots.add(file);
            }
        }
        if (inTestSourceRoots.isEmpty()) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FilesetContainsConfigFilesInTestsSourceValidator.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        if (inTestSourceRoots.size() > 5) {
            return new ValidationResult(SpringBundle.message("fileset.contains.testing.configs.short", inTestSourceRoots.size()));
        }
        String filesText = StringUtil.join(inTestSourceRoots, VirtualFile::getPresentableName, (String)"<br/>");
        return new ValidationResult(SpringBundle.message("fileset.contains.testing.configs.full", inTestSourceRoots.size(), filesText));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/FilesetContainsConfigFilesInTestsSourceValidator", "check"));
    }
}

