/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.nodes.AbstractFilesetNode;
import com.intellij.spring.facet.nodes.CodeGroupNode;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.DependencyNode;
import com.intellij.spring.facet.nodes.FilesetGroupNode;
import com.intellij.spring.facet.nodes.PropertiesGroupNode;
import com.intellij.spring.facet.nodes.XmlGroupNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileSetNode
extends AbstractFilesetNode {
    static final Comparator<ConfigFileNode> FILENAME_COMPARATOR = new FilenameComparator();

    public FileSetNode(@NotNull SpringFileSet fileSet, @NotNull SpringConfigurationTabSettings settings, @NotNull SimpleNode parent) {
        if (fileSet == null) {
            FileSetNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            FileSetNode.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FileSetNode.$$$reportNull$$$0(2);
        }
        super(fileSet, settings, parent);
    }

    public SimpleNode @NotNull [] getChildren() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        SpringFileSet fileSet = this.getFileSet();
        SpringConfigurationTabSettings settings = this.getConfigurationTabSettings();
        Set<SpringFileSet> dependencyFileSets = fileSet.getDependencyFileSets();
        for (SpringFileSet dependencyFileSet : dependencyFileSets) {
            nodes.add((Object)new DependencyNode(dependencyFileSet, settings, this, this.getFileSet().getFacet().getModule()));
        }
        HashSet<VirtualFilePointer> allCustomGroupFiles = new HashSet<VirtualFilePointer>();
        SmartList customConfigFileGroups = new SmartList();
        for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            if (!customization.isApplicable(fileSet)) continue;
            List<SpringFileSetEditorCustomization.CustomConfigFileGroup> groups = customization.getCustomConfigFileGroups(fileSet);
            customConfigFileGroups.addAll(groups);
            for (SpringFileSetEditorCustomization.CustomConfigFileGroup group : groups) {
                allCustomGroupFiles.addAll(group.getFiles());
            }
        }
        Set<VirtualFilePointer> xmlFiles = fileSet.getXmlFiles();
        xmlFiles.removeAll(allCustomGroupFiles);
        Set<VirtualFilePointer> codeFiles = fileSet.getCodeConfigurationFiles();
        codeFiles.removeAll(allCustomGroupFiles);
        if (!xmlFiles.isEmpty() && !codeFiles.isEmpty()) {
            nodes.add((Object)new XmlGroupNode(this, xmlFiles));
            nodes.add((Object)new CodeGroupNode(this, codeFiles));
        } else {
            ArrayList<ConfigFileNode> oneKindOfConfigFiles = new ArrayList<ConfigFileNode>();
            for (VirtualFilePointer file : xmlFiles) {
                oneKindOfConfigFiles.add(new ConfigFileNode(settings, fileSet, file, this));
            }
            for (VirtualFilePointer file : codeFiles) {
                oneKindOfConfigFiles.add(new ConfigFileNode(settings, fileSet, file, this));
            }
            if (settings.isSortAlpha()) {
                oneKindOfConfigFiles.sort(FILENAME_COMPARATOR);
            }
            nodes.addAll(oneKindOfConfigFiles);
        }
        Set<VirtualFilePointer> propertiesFiles = fileSet.getPropertiesFiles();
        propertiesFiles.removeAll(allCustomGroupFiles);
        if (!propertiesFiles.isEmpty()) {
            nodes.add((Object)new PropertiesGroupNode(this, propertiesFiles));
        }
        for (final SpringFileSetEditorCustomization.CustomConfigFileGroup group : customConfigFileGroups) {
            nodes.add((Object)new FilesetGroupNode(this, group.getFiles()){

                @Override
                protected String getGroupName() {
                    return group.getName();
                }

                @Override
                protected Icon getGroupNodeIcon() {
                    return group.getIcon();
                }
            });
        }
        HashSet<VirtualFilePointer> otherFiles = new HashSet<VirtualFilePointer>(fileSet.getFiles());
        otherFiles.removeAll(xmlFiles);
        otherFiles.removeAll(codeFiles);
        otherFiles.removeAll(propertiesFiles);
        otherFiles.removeAll(allCustomGroupFiles);
        if (!otherFiles.isEmpty()) {
            nodes.add((Object)new FilesetGroupNode(this, otherFiles){

                @Override
                protected String getGroupName() {
                    return "Other Files";
                }

                @Override
                protected Icon getGroupNodeIcon() {
                    return AllIcons.FileTypes.Any_type;
                }
            });
        }
        SimpleNode[] simpleNodeArray = nodes.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            FileSetNode.$$$reportNull$$$0(3);
        }
        return simpleNodeArray;
    }

    public boolean isAutoExpandNode() {
        return true;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            FileSetNode.$$$reportNull$$$0(4);
        }
        super.update(presentation);
        presentation.clearText();
        SpringFileSet fileSet = this.getFileSet();
        presentation.addText(fileSet.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (fileSet.isAutodetected()) {
            presentation.addText(" " + SpringBundle.message("facet.context.autodetected.suffix", new Object[0]), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        presentation.setIcon(fileSet.getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/nodes/FileSetNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/nodes/FileSetNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilenameComparator
    implements Comparator<ConfigFileNode> {
        private FilenameComparator() {
        }

        @Override
        public int compare(ConfigFileNode o1, ConfigFileNode o2) {
            return StringUtil.naturalCompare((String)o1.getFilePointer().getFileName(), (String)o2.getFilePointer().getFileName());
        }
    }
}

