/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.editor;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Description;
import com.intellij.spring.model.xml.beans.ScopedElement;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.Nullable;

public class SpringBeanDocumentationProvider
extends AbstractDocumentationProvider {
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        GenericAttributeValue<SpringBeanScope> scope;
        SpringProfile profile;
        JamPsiMemberSpringBean jamPsiMemberSpringBean;
        PsiAnnotation description;
        VirtualFile file;
        CommonSpringBean springBean = SpringBeanPomTargetUtils.getSpringBean(element);
        if (springBean == null || !springBean.isValid()) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append(SpringBeanDocumentationProvider.getSpringBeanTypeName(springBean));
        String beanName = SpringPresentationProvider.getSpringBeanName(springBean);
        sb.append(" <b>").append(StringUtil.escapeXmlEntities((String)beanName)).append("</b>");
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null) {
            sb.append("<br>");
            PsiClassType beanClassType = PsiTypesUtil.getClassType((PsiClass)beanClass);
            JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)beanClassType, (PsiElement)beanClass, (boolean)true);
        }
        if ((file = springBean.getContainingFile().getVirtualFile()) != null) {
            sb.append("<br>");
            sb.append(ProjectUtil.calcRelativeToProjectPath((VirtualFile)file, (Project)element.getProject()));
        }
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        if (springBean instanceof Description) {
            Description description2 = (Description)((Object)springBean);
            String documentation = (String)description2.getDescription().getValue();
            if (StringUtil.isNotEmpty((String)documentation)) {
                sb.append(documentation);
                sb.append("<br><br>");
            }
        } else if (springBean instanceof JamPsiMemberSpringBean && (description = AnnotationUtil.findAnnotation((jamPsiMemberSpringBean = (JamPsiMemberSpringBean)springBean).getPsiElement(), (boolean)true, (String[])new String[]{"org.springframework.context.annotation.Description"})) != null) {
            sb.append(AnnotationUtil.getStringAttributeValue((PsiAnnotation)description, null));
            sb.append("<br><br>");
        }
        sb.append("</div>");
        sb.append("<table class='sections'>");
        String[] aliases = springBean.getAliases();
        if (aliases.length > 0) {
            SpringBeanDocumentationProvider.appendSection(sb, "Aliases", StringUtil.join((String[])aliases, (String)", "));
        }
        if ((profile = springBean.getProfile()) != SpringProfile.DEFAULT) {
            SpringBeanDocumentationProvider.appendSection(sb, "Profile", StringUtil.join(profile.getExpressions(), (String)", "));
        }
        if (springBean instanceof ScopedElement && DomUtil.hasXml(scope = ((ScopedElement)((Object)springBean)).getScope())) {
            SpringBeanDocumentationProvider.appendSection(sb, "Scope", scope.getStringValue());
        }
        sb.append("</table>");
        return sb.toString();
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append(":").append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement, (String)SpringBeanDocumentationProvider.getQuickNavigateInfoInner(element));
    }

    @Nullable
    @NlsSafe
    private static String getQuickNavigateInfoInner(PsiElement element) {
        CommonSpringBean springBean = SpringBeanPomTargetUtils.getSpringBean(element);
        if (springBean == null || !springBean.isValid()) {
            return null;
        }
        String beanName = SpringPresentationProvider.getSpringBeanName(springBean);
        PsiFile containingFile = springBean.getContainingFile();
        StringBuilder sb = new StringBuilder(SpringBeanDocumentationProvider.getSpringBeanTypeName(springBean)).append(" ").append(beanName).append(" [").append(containingFile.getName()).append("]");
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (psiClass != null) {
            sb.append("\n ").append(psiClass.getQualifiedName());
        }
        return sb.toString();
    }

    private static String getSpringBeanTypeName(CommonSpringBean springBean) {
        PsiElement identifyingPsiElement = springBean.getIdentifyingPsiElement();
        assert (identifyingPsiElement != null) : springBean;
        return ElementDescriptionUtil.getElementDescription((PsiElement)identifyingPsiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }
}

