/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetConverter
extends ResolvingConverter.StringConverter {
    private final AtomicNotNullLazyValue<Set<String>> charSets = new AtomicNotNullLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            Set set = ContainerUtil.map2Set((Object[])CharsetToolkit.getAvailableCharsets(), Charset::name);
            if (set == null) {
                1.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/converters/CharsetConverter$1", "compute"));
        }
    };

    public String fromString(String s, ConvertContext convertContext) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        return ((Set)this.charSets.getValue()).contains(s) ? s : null;
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        return LookupElementBuilder.create((String)s).withCaseSensitivity(false);
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext convertContext) {
        Collection collection = (Collection)this.charSets.getValue();
        if (collection == null) {
            CharsetConverter.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return SpringApiBundle.message("cannot.resolve.charset", s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/converters/CharsetConverter", "getVariants"));
    }
}

