/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.beans.MetadataPropertyValueConverter;
import com.intellij.spring.model.xml.beans.MetadataRefValue;
import com.intellij.spring.model.xml.beans.MetadataValue;
import com.intellij.util.ParameterizedTypeImpl;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.ExtendClassImpl;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringToolDomExtender
extends DomExtender<CustomBeanWrapper> {
    @Nullable
    public static XmlTag getToolAnnotationTag(@Nullable PsiElement declaration, boolean allowRecursion) {
        if (declaration instanceof XmlTag) {
            XmlAttributeValue value;
            XmlTag[] tags2;
            XmlTag[] tags1;
            XmlTag xmlTag = (XmlTag)declaration;
            XmlTag[] tags = xmlTag.findSubTags("annotation", "http://www.w3.org/2001/XMLSchema");
            if (tags.length > 0 && (tags1 = tags[0].findSubTags("appinfo", "http://www.w3.org/2001/XMLSchema")).length > 0 && (tags2 = tags1[0].findSubTags("annotation", "http://www.springframework.org/schema/tool")).length > 0) {
                return tags2[0];
            }
            XmlAttribute attribute = xmlTag.getAttribute("type");
            if (allowRecursion && attribute != null && (value = attribute.getValueElement()) != null) {
                for (PsiReference reference : value.getReferences()) {
                    XmlTag annotationTag;
                    PsiElement element = reference.resolve();
                    if (!(element instanceof XmlTag) || (annotationTag = SpringToolDomExtender.getToolAnnotationTag(element, false)) == null) continue;
                    return annotationTag;
                }
            }
        }
        return null;
    }

    public void registerExtensions(@NotNull CustomBeanWrapper element, @NotNull DomExtensionsRegistrar registrar) {
        if (element == null) {
            SpringToolDomExtender.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            SpringToolDomExtender.$$$reportNull$$$0(1);
        }
        if (!element.isValid()) {
            return;
        }
        XmlTag tag = element.getXmlTag();
        assert (tag != null);
        for (XmlAttribute attribute : tag.getAttributes()) {
            XmlTag annotationTag;
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (!(descriptor instanceof XmlAttributeDescriptorImpl) || (annotationTag = SpringToolDomExtender.getToolAnnotationTag(descriptor.getDeclaration(), true)) == null) continue;
            boolean ref = "ref".equals(annotationTag.getAttributeValue("kind"));
            final String expectedType = SpringToolDomExtender.getExpectedTypeClass(annotationTag);
            XmlName xmlName = new XmlName(attribute.getName());
            if (ref) {
                registrar.registerAttributeChildExtension(xmlName, MetadataRefValue.class).setConverter((Converter)new SpringBeanResolveConverter(){

                    @Override
                    @NotNull
                    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
                        if (DumbService.isDumb((Project)context.getProject())) {
                            List<PsiClassType> list = Collections.emptyList();
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }
                        PsiClass psiClass = DomJavaUtil.findClass((String)expectedType, (DomElement)context.getInvocationElement());
                        if (psiClass == null) {
                            List<PsiClassType> list = Collections.emptyList();
                            if (list == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return list;
                        }
                        List<PsiClassType> list = Collections.singletonList(PsiTypesUtil.getClassType((PsiClass)psiClass));
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/dom/SpringToolDomExtender$1", "getRequiredClasses"));
                    }
                });
                continue;
            }
            if ("java.lang.Class".equals(expectedType)) {
                String assignableFrom;
                DomExtension extension = registrar.registerAttributeChildExtension(xmlName, (Type)new ParameterizedTypeImpl(GenericAttributeValue.class, new Type[]{PsiClass.class}));
                XmlTag[] tags1 = annotationTag.findSubTags("assignable-to", "http://www.springframework.org/schema/tool");
                if (tags1.length <= 0 || (assignableFrom = tags1[0].getAttributeValue("type")) == null) continue;
                extension.addCustomAnnotation((Annotation)new ExtendClassImpl(){

                    public String[] value() {
                        return new String[]{assignableFrom};
                    }
                });
                continue;
            }
            registrar.registerAttributeChildExtension(xmlName, MetadataValue.class).setConverter((Converter)new MetadataPropertyValueConverter(expectedType));
        }
    }

    @NotNull
    private static String getExpectedTypeClass(XmlTag annotationTag) {
        XmlTag[] expectedTypeTags = annotationTag.findSubTags("expected-type", "http://www.springframework.org/schema/tool");
        if (expectedTypeTags.length == 0) {
            expectedTypeTags = annotationTag.findSubTags("assignable-to", "http://www.springframework.org/schema/tool");
        }
        String type = expectedTypeTags.length > 0 ? expectedTypeTags[0].getAttributeValue("type") : null;
        String string = type == null ? "java.lang.Object" : type;
        if (string == null) {
            SpringToolDomExtender.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean supportsStubs() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/dom/SpringToolDomExtender";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/dom/SpringToolDomExtender";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

