/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.graph;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalModelDependency {
    private final LocalModelDependencyType myType;
    private final PsiElement myIdentifyingElement;
    @NotNull
    private final String myLabel;

    public static LocalModelDependency create() {
        return new LocalModelDependency("", LocalModelDependencyType.UNKNOWN, null);
    }

    public static LocalModelDependency create(@NotNull LocalModelDependencyType type, @NotNull PsiElement identifyingElement) {
        if (type == null) {
            LocalModelDependency.$$$reportNull$$$0(0);
        }
        if (identifyingElement == null) {
            LocalModelDependency.$$$reportNull$$$0(1);
        }
        Object text = null;
        if (identifyingElement instanceof PsiClass) {
            text = ((PsiClass)identifyingElement).getQualifiedName();
        } else if (identifyingElement instanceof PsiAnnotation) {
            String qualifiedName = ((PsiAnnotation)identifyingElement).getQualifiedName();
            if (qualifiedName != null) {
                text = "@" + qualifiedName;
            }
        } else {
            text = identifyingElement.getText();
        }
        return new LocalModelDependency((String)(text != null ? text : ""), type, identifyingElement);
    }

    public static LocalModelDependency create(@NotNull String label, @NotNull LocalModelDependencyType type, final DomElement identifyingElement) {
        if (label == null) {
            LocalModelDependency.$$$reportNull$$$0(2);
        }
        if (type == null) {
            LocalModelDependency.$$$reportNull$$$0(3);
        }
        return new LocalModelDependency(label, type, (PsiElement)new FakePsiElement(){

            @NotNull
            private XmlElement getXmlElement() {
                XmlElement xmlElement = identifyingElement.getXmlElement();
                assert (xmlElement != null) : identifyingElement;
                XmlElement xmlElement2 = xmlElement;
                if (xmlElement2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return xmlElement2;
            }

            public PsiElement getParent() {
                return this.getXmlElement();
            }

            public void delete() throws IncorrectOperationException {
                this.getXmlElement().delete();
            }

            @NotNull
            public PsiElement getNavigationElement() {
                return this.getXmlElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/graph/LocalModelDependency$1", "getXmlElement"));
            }
        });
    }

    public static LocalModelDependency create(@NotNull String label, @NotNull LocalModelDependencyType type, @Nullable PsiElement identifyingElement) {
        if (label == null) {
            LocalModelDependency.$$$reportNull$$$0(4);
        }
        if (type == null) {
            LocalModelDependency.$$$reportNull$$$0(5);
        }
        return new LocalModelDependency(label, type, identifyingElement);
    }

    private LocalModelDependency(@NotNull String label, @NotNull LocalModelDependencyType type, @Nullable PsiElement identifyingElement) {
        if (label == null) {
            LocalModelDependency.$$$reportNull$$$0(6);
        }
        if (type == null) {
            LocalModelDependency.$$$reportNull$$$0(7);
        }
        this.myLabel = label;
        this.myType = type;
        this.myIdentifyingElement = identifyingElement;
    }

    @NotNull
    public LocalModelDependencyType getType() {
        LocalModelDependencyType localModelDependencyType = this.myType;
        if (localModelDependencyType == null) {
            LocalModelDependency.$$$reportNull$$$0(8);
        }
        return localModelDependencyType;
    }

    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.myIdentifyingElement;
    }

    public String toString() {
        return "LocalModelDependency{" + this.myType + ", " + this.myIdentifyingElement + "}";
    }

    @NotNull
    public String getLabel() {
        String string = this.myLabel;
        if (string == null) {
            LocalModelDependency.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifyingElement";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/graph/LocalModelDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/graph/LocalModelDependency";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

