/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.diagram.gutter.SpringGutterDiagramActionProvider;
import com.intellij.spring.gutter.groups.SpringGroupMergeableLineMarkerInfo;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringCoreIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ModelDependenciesLineMarkerProviderBase
extends LineMarkerProviderDescriptor {
    ModelDependenciesLineMarkerProviderBase() {
    }

    protected abstract boolean isRelevantPsiElement(PsiElement var1);

    @Nullable
    protected abstract LineMarkerInfo<?> doAnnotate(PsiElement var1);

    @Nullable
    public Icon getIcon() {
        return SpringCoreIcons.SpringModelsDependencyGraph;
    }

    public final LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ModelDependenciesLineMarkerProviderBase.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement psiElement;
        if (elements == null) {
            ModelDependenciesLineMarkerProviderBase.$$$reportNull$$$0(1);
        }
        if (result == null) {
            ModelDependenciesLineMarkerProviderBase.$$$reportNull$$$0(2);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringCommonUtils.hasSpringFacets(psiElement.getProject())) {
            return;
        }
        for (PsiElement psiElement2 : elements) {
            PsiFile psiFile;
            if (!this.isRelevantPsiElement(psiElement2) || (psiFile = psiElement2.getContainingFile()) == null || !SpringModelUtils.getInstance().isUsedConfigurationFile(psiFile, false)) continue;
            ContainerUtil.addIfNotNull(result, this.doAnnotate(psiElement2));
        }
    }

    @NotNull
    protected LineMarkerInfo<PsiElement> createLineMarkerInfo(PsiElement element) {
        return new SpringGroupMergeableLineMarkerInfo(element, element.getTextRange(), SpringCoreIcons.Gutter.SpringModelsDependencyGraph, (Function<? super PsiElement, String>)new ConstantFunction((Object)SpringBundle.message("gutter.dependencies.diagram.merged.action.title", new Object[0])), new PsiElementGutterIconNavigationHandler(element));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/contexts/model/diagram/gutter/ModelDependenciesLineMarkerProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PsiElementGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        final List<AnAction> myActions;

        private PsiElementGutterIconNavigationHandler(PsiElement origin) {
            ArrayList<AnAction> diagrams = new ArrayList<AnAction>();
            for (SpringGutterDiagramActionProvider actionProvider : SpringGutterDiagramActionProvider.EP_NAME.getExtensionList()) {
                diagrams.addAll(actionProvider.getOpenDiagramActions(origin));
            }
            diagrams.sort(Comparator.comparing(a -> a.getTemplatePresentation().getText()));
            this.myActions = diagrams;
        }

        public void navigate(MouseEvent e, PsiElement elt) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAll(this.myActions);
            DataContext context = DataManager.getInstance().getDataContext(e.getComponent());
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            popup.show(new RelativePoint(e));
        }
    }
}

