/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.CacheableCommonSpringModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalAnnotationModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalXmlModelWrapper;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class LocalModelWrapper<T extends LocalModel>
extends LocalModelGraphElementWrapper<T> {
    protected LocalModelWrapper(@NotNull T element) {
        if (element == null) {
            LocalModelWrapper.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @Override
    public String getToolTip() {
        @NlsSafe StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        LocalModelWrapper.addTr(sb, SpringBundle.message("model.diagram.element.tooltip.contexts", new Object[0]), this.getLocalModelQualifiedName());
        LocalModelWrapper.addTr(sb, SpringBundle.message("model.diagram.element.tooltip.beans", new Object[0]), ((CacheableCommonSpringModel)this.myElement).getLocalBeans().size());
        LocalModelWrapper.addTr(sb, SpringBundle.message("model.diagram.element.tooltip.component.scans", new Object[0]), ((LocalModel)this.myElement).getPackagesScans().size());
        this.addImportsInformation(sb);
        sb.append("</table></html>");
        return sb.toString();
    }

    @Override
    @NotNull
    public T getElement() {
        LocalModel localModel = (LocalModel)super.getElement();
        if (localModel == null) {
            LocalModelWrapper.$$$reportNull$$$0(1);
        }
        return (T)localModel;
    }

    protected abstract void addImportsInformation(StringBuilder var1);

    @NotNull
    protected abstract String getLocalModelQualifiedName();

    protected static void addTr(@NotNull StringBuilder sb, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, int size) {
        if (sb == null) {
            LocalModelWrapper.$$$reportNull$$$0(2);
        }
        if (title == null) {
            LocalModelWrapper.$$$reportNull$$$0(3);
        }
        if (size > 0) {
            LocalModelWrapper.addTr(sb, title, String.valueOf(size));
        }
    }

    protected static void addTr(@NotNull StringBuilder sb, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title, @NotNull @NlsSafe String value) {
        if (sb == null) {
            LocalModelWrapper.$$$reportNull$$$0(4);
        }
        if (title == null) {
            LocalModelWrapper.$$$reportNull$$$0(5);
        }
        if (value == null) {
            LocalModelWrapper.$$$reportNull$$$0(6);
        }
        sb.append("<tr><td><strong>");
        sb.append(title);
        sb.append(":</strong></td><td>");
        sb.append(value);
        sb.append("</td></tr>");
    }

    @NotNull
    public static LocalModelWrapper create(@NotNull LocalModel model) {
        if (model == null) {
            LocalModelWrapper.$$$reportNull$$$0(7);
        }
        if (model instanceof LocalXmlModel) {
            return new LocalXmlModelWrapper((LocalXmlModel)model);
        }
        if (model instanceof LocalAnnotationModel) {
            return new LocalAnnotationModelWrapper((LocalAnnotationModel)model);
        }
        throw new IllegalArgumentException(String.format("Spring local model '%s' is '%s' while only XML and Annotation models are supported", model.getConfig(), model.getClass().getName()));
    }

    @Override
    public Icon getIcon() {
        return ((LocalModel)this.myElement).getConfig().getIcon(0);
    }

    @Override
    public void accept(@NotNull SpringLocalModelsDataModel.RelatedVisitor visitor) {
        if (visitor == null) {
            LocalModelWrapper.$$$reportNull$$$0(8);
        }
        visitor.visitLocalModel((LocalModel)this.myElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTr";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

