/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NoCacheProcessor<InParams extends SpringModelSearchParameters> {
    protected NoCacheProcessor() {
    }

    @NotNull
    protected abstract Collection<SpringBeanPointer> findPointers(@NotNull InParams var1);

    @Nullable
    protected abstract SpringBeanPointer findFirstPointer(@NotNull InParams var1);

    public boolean process(InParams params, Processor<SpringBeanPointer> processor2, Set<String> activeProfiles) {
        if (processor2 instanceof CommonProcessors.FindFirstProcessor) {
            return NoCacheProcessor.processBeansInActiveProfile(processor2, this.findFirstPointer(params), activeProfiles);
        }
        for (SpringBeanPointer pointer : this.findPointers(params)) {
            if (NoCacheProcessor.processBeansInActiveProfile(processor2, pointer, activeProfiles)) continue;
            return false;
        }
        return true;
    }

    private static boolean processBeansInActiveProfile(Processor<SpringBeanPointer> processor2, @Nullable SpringBeanPointer pointer, Set<String> activeProfiles) {
        if (pointer == null) {
            return true;
        }
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return processor2.process((Object)pointer);
        }
        if (!SpringProfileUtils.isInActiveProfiles(pointer.getSpringBean(), activeProfiles)) {
            return true;
        }
        return processor2.process((Object)pointer);
    }
}

